---
generated_at: 2026-01-21 17:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：13-ルールスクリプトエクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **画面連携**：直接の画面呼び出しがあるか確認
  2. **Experimental表記**：本番利用の可否を確認
  3. **QUASTOスキーマ依存**：生成スクリプトの実行環境要件

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_export_import_rules_pkg.sql` （エクスポート/インポートパッケージ）
- E-02: `src/plsql/pkg/qa_utils_pkg.sql` （ユーティリティパッケージ）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` （機能一覧）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | f_export_rules_to_script_clobがメイン関数である | E-01（242-316行目）、E-03（14行目） | ○ |
| C-02 | 入力パラメータはpi_clob（CLOB型）1つ | E-01（242行目） | ○ |
| C-03 | 'set serveroutput on;'で始まるスクリプトを生成 | E-01（257行目） | ○ |
| C-04 | declare/begin/endのPL/SQLブロックを生成 | E-01（258-263, 298-299行目） | ○ |
| C-05 | REGEXP_SUBSTRで行分割を行う | E-01（266-268行目） | ○ |
| C-06 | REGEXP_COUNTで行数を取得する | E-01（272-275行目） | ○ |
| C-07 | "sql"を含む行を特別処理する | E-01（277-278行目） | ○ |
| C-08 | \nをchr(10)に置換する | E-01（281-283行目: f_replace_string呼出） | ○ |
| C-09 | q記法（q'[]'）を使用する | E-01（290, 293行目） | ○ |
| C-10 | DBMS_LOB.APPENDでCLOB連結する | E-01（289-293行目） | ○ |
| C-11 | quasto.qa_export_import_rules_pkg.p_import_clob_to_rules_tableを呼び出すコードを生成 | E-01（296-297行目） | ○ |
| C-12 | 本関数はDB操作を行わない | E-01（242-316行目: INSERT/UPDATE/DELETE文なし） | ○ |
| C-13 | qa_logger_pkg.append_paramでパラメータログを記録 | E-01（253-255行目） | ○ |
| C-14 | CLOBの先頭4000バイトをログに記録 | E-01（252行目: dbms_lob.substr(pi_clob,4000,1)） | ○ |
| C-15 | NO_DATA_FOUND例外を捕捉する | E-01（303-308行目） | ○ |
| C-16 | OTHERS例外を捕捉する | E-01（309-315行目） | ○ |
| C-17 | 機能名は「ルールスクリプトエクスポート」で番号は13 | E-03（14行目） | ○ |
| C-18 | 「Experimental Function」とコメントされている | E-01（241行目） | ○ |
| C-19 | qa_utils_pkg.f_replace_stringを使用する | E-01（281行目）、E-02 | ○ |
| C-20 | 画面からの直接呼び出しはない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 画面連携の有無（APEXアプリケーションからの直接呼び出し）
  - 候補：APEX画面定義ファイル / プロセス設定

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 「Experimental Function」であり本番利用の判断が必要
- 0: 低リスク - 生成スクリプトはQUASTOスキーマを前提とする
- 0: 低リスク - 大量データでのREGEXP処理のパフォーマンス

## 6) レビュアーチェックリスト（最小）
- [ ] Experimental機能の本番利用可否を確認
- [ ] 生成されたスクリプトの実行環境要件を確認
- [ ] 大量ルールエクスポート時のパフォーマンスを確認
- [ ] q記法の特殊文字（角括弧）がルール内に含まれる場合の挙動を確認
