---
generated_at: 2026-01-21 17:45:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-ユニットテストパッケージ生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり
  2. DDL文の暗黙コミット動作の確認推奨
  3. utPLSQLバージョン互換性の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_unit_tests_pkg.sql` （ユニットテストパッケージ）
- E-02: `src/ddl/tab/qa_rules.sql` （ルールテーブルDDL）
- E-03: `src/scripts/install_constant_package.sql` （定数パッケージ）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` （機能一覧）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | p_create_unit_test_packagesがメイン関数である | E-01（657-823行目）、E-04（15行目） | ○ |
| C-02 | pi_optionとpi_scheme_namesが入力パラメータ | E-01（19-23行目: パッケージ仕様部） | ○ |
| C-03 | pi_optionは1または2のみ有効 | E-01（312-315行目） | ○ |
| C-04 | gc_utplsql_single_packageは定数1 | E-03（16, 48行目） | ○ |
| C-05 | gc_utplsql_single_package_per_ruleは定数2 | E-03（17, 49行目） | ○ |
| C-06 | スキーマ名はqa_scheme_names_for_testing_vで検証 | E-01（323-326行目） | ○ |
| C-07 | qa_main_pkg.f_exist_rulesでルール存在確認 | E-01（353行目） | ○ |
| C-08 | p_delete_unit_test_packagesで既存パッケージを削除 | E-01（678行目, 825-871行目） | ○ |
| C-09 | f_get_all_scheme_namesで全スキーマ取得 | E-01（683行目, 372-401行目） | ○ |
| C-10 | オプション1では単一パッケージを生成 | E-01（686-752行目） | ○ |
| C-11 | オプション2ではルール単位パッケージを生成 | E-01（754-807行目） | ○ |
| C-12 | パッケージ名プレフィックスはQA_UT_ | E-03（18, 50行目: gc_utplsql_ut_test_packages_prefix） | ○ |
| C-13 | EXECUTE IMMEDIATEでパッケージ作成 | E-01（724, 749, 789, 802行目） | ○ |
| C-14 | %suite、%suitepath、%testアノテーションを使用 | E-01（438-439, 475行目） | ○ |
| C-15 | f_get_suitepaがsuitepathを生成 | E-01（216-249行目） | ○ |
| C-16 | suitepathはquasto.{client}.{scheme}形式 | E-01（238行目） | ○ |
| C-17 | qaru_is_active = 1のルールのみ対象 | E-01（695, 711, 733, 767行目） | ○ |
| C-18 | dbms_output.enable(buffer_size => 10000000)を呼び出す | E-01（671行目） | ○ |
| C-19 | Unit Test Generation画面から操作可能 | E-05（6行目） | ○ |
| C-20 | 機能名は「ユニットテストパッケージ生成」で番号は14 | E-04（15行目） | ○ |
| C-21 | AUTHID DEFINER権限で実行 | E-01（1行目） | ○ |
| C-22 | DROP PACKAGE文で既存パッケージを削除 | E-01（844, 855行目） | ○ |
| C-23 | user_objectsから既存パッケージを検索 | E-01（838-841, 849-852行目） | ○ |
| C-24 | パッケージ仕様部にc_scheme_name、c_client_name定数を定義 | E-01（441-442行目） | ○ |
| C-25 | f_get_unified_stringで名前を正規化 | E-01（693, 707-708, 763-765行目） | ○ |
| C-26 | DBMS_OUTPUTでログを出力 | E-01（725, 750, 790, 803行目） | ○ |
| C-27 | エラー時にqa_logger_pkg.p_qa_logでログ記録 | E-01（817-820行目） | ○ |
| C-28 | p_validate_inputで入力検証を行う | E-01（299-344, 673-674行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - DDL文の暗黙コミットにより部分的な状態が残る可能性
- 0: 低リスク - utPLSQLのバージョンによるアノテーション互換性
- 0: 低リスク - 多数のスキーマ・ルールでの生成時間

## 6) レビュアーチェックリスト（最小）
- [ ] utPLSQLがインストールされていることを確認
- [ ] CREATE PROCEDURE権限があることを確認
- [ ] 生成パッケージがコンパイルエラーなく作成されることを確認
- [ ] suitepathが正しく設定されutPLSQLで認識されることを確認
