---
generated_at: 2026-01-21 17:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-ユニットテストパッケージ削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり
  2. DDL暗黙コミットの影響確認推奨
  3. 削除対象パッケージの事前確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_unit_tests_pkg.sql` （ユニットテストパッケージ）
- E-02: `src/scripts/install_constant_package.sql` （定数パッケージ）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` （機能一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | p_delete_unit_test_packagesがメイン関数である | E-01（825-871行目）、E-03（16行目） | ○ |
| C-02 | pi_scheme_namesはオプションパラメータ | E-01（29行目: DEFAULT null） | ○ |
| C-03 | スキーマ名指定時はスキーマごとにループ | E-01（836-847行目） | ○ |
| C-04 | スキーマ名未指定時は全パッケージを対象 | E-01（848-858行目） | ○ |
| C-05 | QA_UT_プレフィックスでパッケージを検索 | E-01（841, 852行目） | ○ |
| C-06 | gc_utplsql_ut_test_packages_prefixは'QA_UT_' | E-02（18, 50行目） | ○ |
| C-07 | user_objectsからPACKAGE型を検索 | E-01（839, 850行目: object_type = 'PACKAGE'） | ○ |
| C-08 | DROP PACKAGE文をEXECUTE IMMEDIATEで実行 | E-01（844, 855行目） | ○ |
| C-09 | DBMS_OUTPUT.PUT_LINEでログ出力 | E-01（845, 856行目） | ○ |
| C-10 | LIKE条件でアンダースコアをエスケープ | E-01（841, 852行目: escape '\'） | ○ |
| C-11 | エラー時にqa_logger_pkg.p_qa_logでログ記録 | E-01（866-869行目） | ○ |
| C-12 | Unit Test Generation画面から操作可能 | E-04（7行目） | ○ |
| C-13 | 機能名は「ユニットテストパッケージ削除」で番号は15 | E-03（16行目） | ○ |
| C-14 | p_create_unit_test_packagesから呼び出される | E-01（678行目） | ○ |
| C-15 | p_delete_unit_tests_for_schemesがラッパー関数 | E-01（1523-1552行目）、E-01（207-210行目: 仕様部） | ○ |
| C-16 | ラッパーはコロン区切り文字列を配列に変換 | E-01（1540-1541行目） | ○ |
| C-17 | OTHERS例外を捕捉する | E-01（860-870行目） | ○ |
| C-18 | 削除結果として「Drop of package ... successful」を出力 | E-01（845, 856行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - DDL文の暗黙コミットにより削除が即座に確定
- 0: 低リスク - 誤って全パッケージを削除する可能性（スキーマ名未指定時）
- 0: 低リスク - 途中エラー時に部分的な削除状態が残る

## 6) レビュアーチェックリスト（最小）
- [ ] 削除対象パッケージの事前確認方法を確認
- [ ] 誤削除時の復旧手順を確認
- [ ] スキーマ名指定時のパターンマッチングが正しいか確認
