---
generated_at: 2026-01-21 17:55:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-全ユニットテスト実行

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり
  2. utPLSQLのインストール確認推奨
  3. 文字コード（Windows-1251）の妥当性確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_unit_tests_pkg.sql` （ユニットテストパッケージ）
- E-02: `src/ddl/tab/qa_test_results.sql` （テスト結果テーブルDDL）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` （機能一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | f_run_all_unit_testsがメイン関数である | E-01（935-988行目）、E-03（17行目） | ○ |
| C-02 | p_run_all_unit_testsはラッパープロシージャ | E-01（918-933行目） | ○ |
| C-03 | pi_quasto_schemeのデフォルトはCURRENT_USER | E-01（61行目） | ○ |
| C-04 | pi_character_setのデフォルトはWindows-1251 | E-01（62行目） | ○ |
| C-05 | pi_quasto_scheme/pi_character_setがNULLならエラー | E-01（958-961行目） | ○ |
| C-06 | クライアント名・スキーマ名両方指定時のみ特定suitepath | E-01（963-968行目） | ○ |
| C-07 | f_get_suitepatでsuitepathを生成 | E-01（965, 967行目） | ○ |
| C-08 | suitepathはquasto.{client}.{scheme}形式 | E-01（238行目） | ○ |
| C-09 | dbms_output.enable(buffer_size => 1000000)を呼び出す | E-01（970行目） | ○ |
| C-10 | ut.run関数を呼び出す | E-01（973行目） | ○ |
| C-11 | ut_junit_reporter()をレポーターとして使用 | E-01（973行目） | ○ |
| C-12 | DBMS_XMLGEN.CONVERTでXML変換 | E-01（971行目） | ○ |
| C-13 | XMLAGG、XMLELEMENTでCLOB変換 | E-01（971行目） | ○ |
| C-14 | QA_TEST_RESULTSにINSERTする | E-01（976-977行目） | ○ |
| C-15 | qatr_descriptionに'Executed by Suite Path:'を設定 | E-01（977行目） | ○ |
| C-16 | Config Scheduler Job画面から操作可能 | E-04（26行目） | ○ |
| C-17 | 機能名は「全ユニットテスト実行」で番号は16 | E-03（17行目） | ○ |
| C-18 | CLOBを返却する | E-01（979行目） | ○ |
| C-19 | エラー時にqa_logger_pkg.p_qa_logでログ記録 | E-01（982-985行目） | ○ |
| C-20 | DBMS_OUTPUT.disableを例外時に呼び出す | E-01（986行目） | ○ |
| C-21 | a_client_character_setパラメータを使用 | E-01（973行目） | ○ |
| C-22 | ラッパーp_run_all_unit_testsはf_run_all_unit_testsを呼び出す | E-01（925行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - utPLSQLがインストールされていない環境でのエラー
- 0: 低リスク - Windows-1251文字コードの環境依存性
- 0: 低リスク - 大量テスト実行時の処理時間とメモリ使用量

## 6) レビュアーチェックリスト（最小）
- [ ] utPLSQLがインストールされていることを確認
- [ ] テストパッケージが生成されていることを確認
- [ ] 文字コード設定が環境に適切か確認
- [ ] 長時間実行時のタイムアウト設定を確認
