---
generated_at: 2026-01-21 18:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-単一ユニットテスト実行

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり
  2. テストパッケージの事前生成確認推奨
  3. パラメータの有効性確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_unit_tests_pkg.sql` （ユニットテストパッケージ）
- E-02: `src/ddl/tab/qa_test_results.sql` （テスト結果テーブルDDL）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` （機能一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | p_run_custom_unit_testがメイン関数である | E-01（990-1036行目）、E-03（18行目） | ○ |
| C-02 | pi_qaru_rule_number、pi_qaru_client_name、pi_scheme_name、pi_character_setが入力パラメータ | E-01（71-77行目: 仕様部） | ○ |
| C-03 | pi_character_setのデフォルトはWindows-1251 | E-01（76行目） | ○ |
| C-04 | 全パラメータがNULLでないことを検証 | E-01（1012-1015行目） | ○ |
| C-05 | f_get_unit_test_callで呼び出しパスを取得 | E-01（1017行目） | ○ |
| C-06 | f_get_unit_test_callはuser_objectsからパッケージ名を検索 | E-01（282-287行目） | ○ |
| C-07 | オプション1とオプション2の両方のパッケージ命名規則に対応 | E-01（286-287行目: IN句） | ○ |
| C-08 | 呼び出しパスはpackage.procedure形式 | E-01（289行目） | ○ |
| C-09 | dbms_output.enable(buffer_size => 1000000)を呼び出す | E-01（1019行目） | ○ |
| C-10 | ut.run関数を呼び出す | E-01（1022行目） | ○ |
| C-11 | QA_TEST_RESULTSにINSERTする | E-01（1025-1026行目） | ○ |
| C-12 | qatr_descriptionに'Executed by PL/SQL Call:'を設定 | E-01（1026行目） | ○ |
| C-13 | Restart Unit Test画面から操作可能 | E-04（27行目） | ○ |
| C-14 | 機能名は「単一ユニットテスト実行」で番号は17 | E-03（18行目） | ○ |
| C-15 | QA_RULESからルール名を取得 | E-01（273-277行目） | ○ |
| C-16 | qa_utils_pkg.f_get_unified_stringで名前を正規化 | E-01（273, 279, 280行目） | ○ |
| C-17 | エラー時にqa_logger_pkg.p_qa_logでログ記録 | E-01（1030-1033行目） | ○ |
| C-18 | DBMS_OUTPUT.disableを例外時に呼び出す | E-01（1034行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テストパッケージが未生成の場合のエラー
- 0: 低リスク - 存在しないルール番号指定時のエラー

## 6) レビュアーチェックリスト（最小）
- [ ] 指定するルール番号・クライアント名が正しいか確認
- [ ] 対応するテストパッケージが生成されているか確認
- [ ] スキーマ名が正しいか確認
