---
generated_at: 2026-01-21 18:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-カスタムテストジョブ作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり
  2. CREATE JOB権限の確認推奨
  3. 同時実行制御の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_unit_tests_pkg.sql` （ユニットテストパッケージ）
- E-02: `src/scripts/install_constant_package.sql` （定数パッケージ）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` （機能一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | p_create_custom_unit_test_jobがメイン関数である | E-01（873-916行目）、E-03（19行目） | ○ |
| C-02 | pi_qaru_rule_number、pi_qaru_client_name、pi_scheme_nameが入力パラメータ | E-01（37-42行目: 仕様部） | ○ |
| C-03 | 開始時刻は5秒後 | E-01（892行目: interval '5' second） | ○ |
| C-04 | f_get_job_nameでベースジョブ名を取得 | E-01（893-896行目） | ○ |
| C-05 | タイムスタンプをジョブ名に付加 | E-01（897行目: to_char(l_job_start_date,'YYYYMMDDHH24MISS')） | ○ |
| C-06 | DBMS_SCHEDULER.CREATE_JOBを呼び出す | E-01（899-907行目） | ○ |
| C-07 | job_typeはPLSQL_BLOCK | E-01（901行目） | ○ |
| C-08 | enabledはtrue | E-01（904行目） | ○ |
| C-09 | auto_dropはtrue | E-01（905行目） | ○ |
| C-10 | job_actionはp_run_custom_unit_test呼び出し | E-01（902行目） | ○ |
| C-11 | gc_utplsql_custom_scheduler_job_nameは'JOB_RUN_UNIT_TEST' | E-02（20, 52行目） | ○ |
| C-12 | f_get_job_nameはpi_is_cronjobでジョブ種別を区別 | E-01（1174行目, 1195-1210行目） | ○ |
| C-13 | Restart Unit Test画面から操作可能 | E-04（28行目） | ○ |
| C-14 | 機能名は「カスタムテストジョブ作成」で番号は18 | E-03（19行目） | ○ |
| C-15 | エラー時にqa_logger_pkg.p_qa_logでログ記録 | E-01（911-914行目） | ○ |
| C-16 | commentsにジョブ説明を設定 | E-01（906行目） | ○ |
| C-17 | qa_utils_pkg.f_get_unified_stringで名前を正規化 | E-01（1205-1207行目） | ○ |
| C-18 | カスタムジョブ名は{PREFIX}_{SCHEME}_{CLIENT}_{RULE}形式 | E-01（1209行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - CREATE JOB権限がない場合のエラー
- 0: 低リスク - 同一ルールの同時実行
- 0: 低リスク - ジョブ作成の暗黙コミット

## 6) レビュアーチェックリスト（最小）
- [ ] DBMS_SCHEDULER使用権限があることを確認
- [ ] 同一ルールの同時実行が許容されるか確認
- [ ] ジョブ実行時のエラーハンドリングを確認
