---
generated_at: 2026-01-21 18:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-スケジューラジョブ制御

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり
  2. ジョブ定義の存在確認推奨
  3. 権限設定の確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_unit_tests_pkg.sql` （ユニットテストパッケージ）
- E-02: `src/scripts/install_constant_package.sql` （定数パッケージ）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` （機能一覧）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面機能マッピング）
- E-05: `src/plsql/vw/qa_job_details_P0009_v.sql` （ジョブ詳細ビュー）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | p_enable_scheduler_cronjobで有効/無効を切り替える | E-01（1335-1364行目）、E-03（20行目） | ○ |
| C-02 | p_trigger_scheduler_cronjobで手動トリガーする | E-01（1366-1386行目）、E-03（20行目） | ○ |
| C-03 | f_is_scheduler_cronjob_enabledで状態確認 | E-01（1304-1333行目） | ○ |
| C-04 | pi_statusは'Y'または'N'のみ許可 | E-01（1345-1349行目） | ○ |
| C-05 | 'Y'の場合はDBMS_SCHEDULER.ENABLEを呼び出す | E-01（1353行目） | ○ |
| C-06 | 'N'の場合はDBMS_SCHEDULER.DISABLEを呼び出す | E-01（1355行目） | ○ |
| C-07 | f_is_job_runningで実行中を確認 | E-01（1372行目） | ○ |
| C-08 | 実行中の場合はエラー | E-01（1376行目） | ○ |
| C-09 | DBMS_SCHEDULER.RUN_JOBでジョブを実行 | E-01（1374行目） | ○ |
| C-10 | use_current_session => falseで非同期実行 | E-01（1374行目） | ○ |
| C-11 | gc_utplsql_scheduler_cronjob_nameは'CRONJOB_RUN_UNIT_TESTS' | E-02（19, 51行目） | ○ |
| C-12 | USER_SCHEDULER_JOBSからenabledを確認 | E-01（1316-1318行目） | ○ |
| C-13 | USER_SCHEDULER_RUNNING_JOBSから実行中を確認 | E-01（1285-1287行目） | ○ |
| C-14 | Config Scheduler Job画面から操作可能 | E-04（25行目） | ○ |
| C-15 | 機能名は「スケジューラジョブ制御」で番号は19 | E-03（20行目） | ○ |
| C-16 | エラー時にqa_logger_pkg.p_qa_logでログ記録 | E-01（1358-1361, 1380-1383行目） | ○ |
| C-17 | f_is_job_runningは任意のジョブ名を受け付ける | E-01（1270行目: pi_job_name in varchar2） | ○ |
| C-18 | ジョブ名でjob_nameを検索 | E-01（1317, 1287行目） | ○ |
| C-19 | 戻り値は'Y'または'N' | E-01（1320-1325, 1289-1294行目） | ○ |
| C-20 | qa_job_details_P0009_vでジョブ詳細を表示 | E-05 | ○ |
| C-21 | ビューでgc_utplsql_scheduler_cronjob_nameを使用 | E-05（5行目） | ○ |
| C-22 | pi_status検証失敗時は-20001エラー | E-01（1348行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ジョブが未定義の場合のエラー
- 0: 低リスク - ALTER ANY JOB権限がない場合のエラー

## 6) レビュアーチェックリスト（最小）
- [ ] CRONJOB_RUN_UNIT_TESTSジョブが存在することを確認
- [ ] DBMS_SCHEDULER使用権限があることを確認
- [ ] ジョブスケジュール設定が適切か確認
