---
generated_at: 2026-01-21 16:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：2-単一ルール実行

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_api_pkg.sql` - 単一ルール実行関数
- E-02: `src/plsql/pkg/qa_main_pkg.sql` - ルール管理補助関数
- E-03: `src/plsql/typ/qa_rule_t.sql` - ルール型定義
- E-04: `src/plsql/vw/qa_scheme_names_for_testing_v.sql` - テスト対象スキーマビュー
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tf_run_rule関数として実装 | E-01 (24-29行目, 49-151行目) | ○ |
| C-02 | 3つの入力パラメータ（ルール番号、クライアント名、対象スキーマ） | E-01 (24-29行目) | ○ |
| C-03 | pi_target_schemeのデフォルト値はUSER | E-01 (28行目, 53行目) | ○ |
| C-04 | 必須パラメータのNULLチェック | E-01 (74-80行目) | ○ |
| C-05 | ブラックリストスキーマのチェック | E-01 (82-83行目), E-02 (1006-1056行目) | ○ |
| C-06 | ルールアクティブチェック | E-01 (85-91行目), E-02 (290-326行目) | ○ |
| C-07 | f_get_rule関数でルール定義を取得 | E-01 (93-94行目), E-02 (213-256行目) | ○ |
| C-08 | APEXルールと非APEXルールでバインド変数が異なる | E-01 (97-122行目) | ○ |
| C-09 | 非APEXは7バインド変数、APEXは9バインド変数 | E-01 (99-108行目, 110-121行目) | ○ |
| C-10 | 条件付きコンパイルでAPEX連携制御 | E-01 (124-132行目) | ○ |
| C-11 | p_exclude_not_whitelisted_apex_entries呼び出し | E-01 (128行目) | ○ |
| C-12 | p_exclude_objects呼び出し | E-01 (134行目), E-02 (842-897行目) | ○ |
| C-13 | qa_rules_t型で結果を返却 | E-01 (29行目, 135行目) | ○ |
| C-14 | ブラックリスト時はNULL返却 | E-01 (136-138行目) | ○ |
| C-15 | NO_DATA_FOUND例外時はログ記録 | E-01 (140-144行目) | ○ |
| C-16 | その他例外時はログ記録後re-raise | E-01 (145-150行目) | ○ |
| C-17 | authid current_userで実行 | E-01 (2行目) | ○ |
| C-18 | Region Plugin画面(No.12)から呼び出し | E-05 (29行目) | ○ |
| C-19 | ブラックリストスキーマはall_usersから特定スキーマを除外 | E-04 (1-79行目) | ○ |
| C-20 | -20001エラーコードで例外発生 | E-01 (78-80行目, 89-91行目) | ○ |
| C-21 | -20007エラーコードでブラックリスト例外 | E-02 (1044-1045行目) | ○ |
| C-22 | パフォーマンス要件：10秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の根拠**
  - 理由：ソースコード・設計書に明示的な性能要件の記載がない
  - 候補：非機能要件定義書 / システム設計書 / 性能テスト結果

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 関数仕様、パラメータ、処理フローはソースコードで明確に確認済み
- **1（中リスク）**: パフォーマンス要件は推測値のため、実運用時に要検証
- **0（低リスク）**: 例外処理、エラーコードはソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] tf_run_rule関数の3つのパラメータが正しく記載されているか
- [ ] バインド変数の数（7個/9個）が正確か
- [ ] 条件付きコンパイル（$IF gc_apex_flag = 1 $THEN）の説明が正確か
- [ ] コードリーディングガイドの行番号が現在のソースと一致しているか
- [ ] パフォーマンス要件の妥当性を確認
