---
generated_at: 2026-01-21 18:15:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-テスト結果処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. 特になし - すべての主張に根拠あり
  2. utPLSQLとの連携動作確認推奨
  3. XML出力のバッファサイズ確認推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_unit_tests_pkg.sql` （ユニットテストパッケージ）
- E-02: `src/scripts/install_constant_package.sql` （定数パッケージ）
- E-03: `src/ddl/tab/qa_test_runs.sql` （テスト実行テーブルDDL）
- E-04: `src/ddl/tab/qa_test_run_invalid_objects.sql` （無効オブジェクトテーブルDDL）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` （機能一覧）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面機能マッピング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | p_handle_test_resultがメイン関数である | E-01（1072-1141行目）、E-05（21行目） | ○ |
| C-02 | pi_qaru_rule_number、pi_qaru_client_name、pi_scheme_objects、pi_invalid_objects、pi_result、pi_program_nameが入力パラメータ | E-01（1073-1079行目） | ○ |
| C-03 | 自律トランザクション（pragma autonomous_transaction）で実行 | E-01（1081行目） | ○ |
| C-04 | ut.expect(pi_result).to_equal(1)でアサーション | E-01（1090行目） | ○ |
| C-05 | qa_main_pkg.f_get_rule_pkでルールIDを取得 | E-01（1091-1092行目） | ○ |
| C-06 | qa_main_pkg.f_get_rule_categoryでカテゴリを取得 | E-01（1093-1094行目） | ○ |
| C-07 | qa_main_pkg.f_get_rule_nameでルール名を取得 | E-01（1095-1096行目） | ○ |
| C-08 | qa_main_pkg.f_get_rule_layerでレイヤーを取得 | E-01（1097-1098行目） | ○ |
| C-09 | qa_main_pkg.f_get_rule_error_levelでエラーレベルを取得 | E-01（1099-1100行目） | ○ |
| C-10 | DBMS_OUTPUT.PUT_LINEでXML形式で出力 | E-01（1102, 1114, 1120, 1129, 1135, 1138行目） | ○ |
| C-11 | DBMS_XMLGEN.CONVERTでエスケープ処理 | E-01（1102, 1114, 1120, 1129行目） | ○ |
| C-12 | object_amount = 0の場合は成功（gc_utplsql_scheme_result_success）として保存 | E-01（1108-1114行目） | ○ |
| C-13 | object_amount > 0の場合は失敗（gc_utplsql_scheme_result_failure）として保存 | E-01（1115-1120行目） | ○ |
| C-14 | f_save_scheme_resultでQA_TEST_RUNSにINSERT | E-01（1055-1057行目） | ○ |
| C-15 | p_save_scheme_faulty_objectsでQA_TEST_RUN_INVALID_OBJECTSにINSERT | E-01（1068-1069行目） | ○ |
| C-16 | 処理完了時にCOMMIT | E-01（1139行目） | ○ |
| C-17 | gc_utplsql_scheme_result_failure = 0 | E-02（21, 53行目） | ○ |
| C-18 | gc_utplsql_scheme_result_success = 1 | E-02（22, 54行目） | ○ |
| C-19 | gc_utplsql_scheme_result_error = 2 | E-02（23, 55行目） | ○ |
| C-20 | QA_TEST_RUNSテーブルにqatr_scheme_name、qatr_date、qatr_result、qatr_qaru_id、qatr_program_nameをINSERT | E-01（1055-1056行目）、E-03（6-13行目） | ○ |
| C-21 | QA_TEST_RUN_INVALID_OBJECTSテーブルにqato_object_name、qato_object_details、qato_qatr_idをINSERT | E-01（1068-1069行目）、E-04（7-9行目） | ○ |
| C-22 | pi_resultが無効な場合は-20001エラー | E-01（1052行目） | ○ |
| C-23 | 機能名は「テスト結果処理」で番号は20 | E-05（21行目） | ○ |
| C-24 | Dashboard画面でテスト結果を表示 | E-06（4行目: 画面No=2でQA_TEST_RUNSを参照） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし（すべての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - DBMS_OUTPUTバッファオーバーフロー
- 0: 低リスク - 大量の無効オブジェクト時のパフォーマンス

## 6) レビュアーチェックリスト（最小）
- [ ] utPLSQLテスト実行時にXMLが正しく出力されることを確認
- [ ] QA_TEST_RUNSに結果が正しく保存されることを確認
- [ ] QA_TEST_RUN_INVALID_OBJECTSに無効オブジェクトが保存されることを確認
