---
generated_at: 2026-01-21 17:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：21-テスト例外処理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **エラー定数値の具体値**：qa_constant_pkgの定義ファイルが見つからず、gc_utplsql_scheme_result_errorの具体値が確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_unit_tests_pkg.sql` - パッケージ仕様部・本体
- E-02: `src/ddl/tab/qa_test_runs.sql` - QA_TEST_RUNSテーブル定義
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | p_handle_test_exceptionはランタイムエラーを処理・保存する | E-01 (1143-1168行目) | ○ |
| C-02 | PRAGMA AUTONOMOUS_TRANSACTIONが使用されている | E-01 (1151行目) | ○ |
| C-03 | 入力パラメータは5つ存在する | E-01 (106-113行目) | ○ |
| C-04 | スキーマ名配列をカンマ区切り文字列に変換する | E-01 (1156-1157行目) | ○ |
| C-05 | qa_main_pkg.f_get_rule_pkでルール主キーを取得する | E-01 (1158-1159行目) | ○ |
| C-06 | f_save_scheme_resultでテスト結果を保存する | E-01 (1160-1163行目) | ○ |
| C-07 | QA_TEST_RUNSテーブルのqatr_runtime_errorを更新する | E-01 (1164-1166行目) | ○ |
| C-08 | COMMITを実行する | E-01 (1167行目) | ○ |
| C-09 | Runtime Error画面と関連する | E-03 | ○ |
| C-10 | 生成されたテストパッケージから呼び出される | E-01 (600-607行目) | ○ |
| C-11 | エラー状態として記録される | E-01 (1163行目) | ○ |
| C-12 | QA_TEST_RUNSテーブルにqatr_runtime_error列が存在する | E-02 (12行目) | ○ |
| C-13 | AUTHID DEFINERで定義されている | E-01 (1行目) | ○ |
| C-14 | エラーバックトレースはSQLERRM + format_error_backtraceで構成 | E-01 (606行目) | ○ |
| C-15 | f_save_scheme_resultはエラー結果定数を使用 | E-01 (1163行目) | ○ |
| C-16 | 生成パッケージのEXCEPTIONハンドラから呼び出される | E-01 (600-607行目) | ○ |
| C-17 | パッケージ目的はutPLSQL連携 | E-01 (3-6行目) | ○ |
| C-18 | gc_utplsql_scheme_result_errorの具体値 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- qa_constant_pkgの定義ファイルが見つからず、定数値の具体的な値を確認できない
  - 候補：qa_constant_pkg.sql / qa_constant_pkg.pks / src/plsql/pkg/qa_constant*.sql

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本機能の主要なロジックはソースコードで確認できる
- 1: 中リスク - 定数値の具体値が未確認のため、エラー状態の判定ロジックの完全な理解には追加調査が必要

## 6) レビュアーチェックリスト（最小）
- [ ] p_handle_test_exceptionの5つの入力パラメータが正しく記載されているか確認
- [ ] 自律トランザクションの動作が正しく説明されているか確認
- [ ] QA_TEST_RUNSテーブルへの操作（INSERT/UPDATE）が正しいか確認
- [ ] qa_constant_pkg.gc_utplsql_scheme_result_errorの具体値を確認し、必要に応じて設計書を更新
