---
generated_at: 2026-01-21 17:24:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-テスト結果エクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/plsql/pkg/qa_unit_tests_pkg.sql` - パッケージ仕様部・本体
- E-02: `src/plsql/pkg/qa_apex_app_pkg.sql` - APEX連携パッケージ
- E-03: `src/ddl/tab/qa_test_results.sql` - QA_TEST_RESULTSテーブル定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | f_export_test_resultはXML CLOBをエクスポートする | E-01 (1460-1486行目) | ○ |
| C-02 | 入力パラメータはpi_qatr_id（qa_test_results.qatr_id%type）のみ | E-01 (188-193行目) | ○ |
| C-03 | 戻り値はCLOB型 | E-01 (193行目) | ○ |
| C-04 | QA_TEST_RESULTSテーブルからSELECTする | E-01 (1473-1476行目) | ○ |
| C-05 | qatr_xml_result列を取得する | E-01 (1473行目) | ○ |
| C-06 | WHERE句でqatr_idを指定 | E-01 (1476行目) | ○ |
| C-07 | Test Result Files画面と関連 | E-04 | ○ |
| C-08 | p_download_unit_test_xml経由で呼び出される | E-02 (264行目) | ○ |
| C-09 | HTTPレスポンスでXMLをダウンロード | E-02 (271-283行目) | ○ |
| C-10 | qatr_added_onを取得してファイル名に使用 | E-02 (266-269行目, 276行目) | ○ |
| C-11 | チャンク単位で出力 | E-02 (279-283行目) | ○ |
| C-12 | エラー時はqa_logger_pkgでログ記録 | E-01 (1481-1484行目) | ○ |
| C-13 | AUTHID DEFINERで定義 | E-01 (1行目) | ○ |
| C-14 | QA_TEST_RESULTSにqatr_xml_result列（CLOB）が存在 | E-03 (7行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本機能の主要なロジックはソースコードで完全に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] f_export_test_resultの入力パラメータと戻り値が正しく記載されているか確認
- [ ] QA_TEST_RESULTSテーブルからのSELECT条件が正しいか確認
- [ ] 呼び出し元（p_download_unit_test_xml）との連携が正しく説明されているか確認
