---
generated_at: 2026-01-21 17:26:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：24-APEXルール実行

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **qa_rule_t/qa_rules_t型定義ファイル**：型定義ファイルの具体的な場所が確認できない

## 2) 参照した情報（Evidence一覧）

- E-01: `src/plsql/pkg/qa_apex_api_pkg.sql` - APEX API パッケージ仕様部・本体
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tf_run_ruleはAPEXルールを実行する | E-01 (99-182行目) | ○ |
| C-02 | tf_run_rulesは複数ルールを一括実行する | E-01 (184-233行目) | ○ |
| C-03 | 入力パラメータにpi_app_id、pi_page_id、pi_qaru_rule_number、pi_qaru_client_name、pi_target_schemeがある | E-01 (19-26行目) | ○ |
| C-04 | ルール番号またはクライアント名がNULLの場合は例外を発生させる | E-01 (123-128行目) | ○ |
| C-05 | ルールのアクティブ状態を確認する | E-01 (130-131行目) | ○ |
| C-06 | 非アクティブなルールは例外を発生させる | E-01 (132-136行目) | ○ |
| C-07 | qa_main_pkg.f_get_ruleでルール情報を取得する | E-01 (138-139行目) | ○ |
| C-08 | APEXカテゴリの場合はapp_id、page_idをバインドしてSQL実行 | E-01 (141-154行目) | ○ |
| C-09 | その他のカテゴリの場合は標準バインド変数でSQL実行 | E-01 (158-167行目) | ○ |
| C-10 | p_exclude_not_whitelisted_apex_entriesでブラックリスト除外 | E-01 (156行目) | ○ |
| C-11 | Region Plugin画面と関連 | E-02 | ○ |
| C-12 | AUTHID DEFINERで定義 | E-01 (1行目) | ○ |
| C-13 | qa_apex_blacklisted_apps_vビューを参照 | E-01 (63行目) | ○ |
| C-14 | エラー時はqa_logger_pkgでログ記録 | E-01 (91-94行目, 173-180行目) | ○ |
| C-15 | tf_run_rulesはAPEXカテゴリのアクティブルールをループ実行 | E-01 (206-211行目) | ○ |
| C-16 | multiset unionで結果を集約 | E-01 (218行目) | ○ |
| C-17 | 戻り値はqa_rules_t型 | E-01 (26行目) | ○ |
| C-18 | qa_rule_t/qa_rules_t型の具体的な属性定義 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- qa_rule_t / qa_rules_t型の定義ファイルが見つからない
  - 候補：src/plsql/typ/qa_rule_t.sql / src/plsql/typ/qa_rules_t.sql

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本機能の主要なロジックはソースコードで確認できる
- 1: 中リスク - 戻り値の型の属性定義が未確認のため、結果データの構造の完全な理解には追加調査が必要

## 6) レビュアーチェックリスト（最小）
- [ ] tf_run_rule、tf_run_rules関数の入力パラメータが正しく記載されているか確認
- [ ] APEXカテゴリとその他のカテゴリでの処理分岐が正しいか確認
- [ ] ブラックリスト除外処理が正しく説明されているか確認
- [ ] qa_rule_t / qa_rules_t型の属性を確認し、必要に応じて設計書を更新
