---
generated_at: 2026-01-21 17:28:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：25-APEXブラックリスト除外

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **qa_apex_blacklisted_apps_vビュー定義**：ビューの定義ファイルが見つからず、具体的な構造が確認できない

## 2) 参照した情報（Evidence一覧）

- E-01: `src/plsql/pkg/qa_apex_api_pkg.sql` - APEX API パッケージ仕様部・本体
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | p_exclude_not_whitelisted_apex_entriesはブラックリスト除外を行う | E-01 (41-96行目) | ○ |
| C-02 | 入力パラメータはIN OUTのqa_rules_t型 | E-01 (17行目) | ○ |
| C-03 | コレクションが空の場合は処理終了 | E-01 (49行目) | ○ |
| C-04 | QA_RULESからqaru_app_id、qaru_page_idを取得 | E-01 (51-56行目) | ○ |
| C-05 | qa_apex_blacklisted_apps_vでブラックリストチェック | E-01 (60-64行目) | ○ |
| C-06 | instr関数でapp_idリストをチェック | E-01 (66-67行目) | ○ |
| C-07 | apex_string.splitでpage_idを分割 | E-01 (74-76行目) | ○ |
| C-08 | 条件に合致しない場合はコレクションから削除 | E-01 (71行目, 83行目) | ○ |
| C-09 | コレクションの最初の要素のqaru_idを使用 | E-01 (56行目) | ○ |
| C-10 | エラー時はqa_logger_pkgでログ記録 | E-01 (91-94行目) | ○ |
| C-11 | AUTHID DEFINERで定義 | E-01 (1行目) | ○ |
| C-12 | tf_run_ruleから呼び出される | E-01 (156行目) | ○ |
| C-13 | ブラックリストカウントが0より大きい場合は除外 | E-01 (69行目) | ○ |
| C-14 | page_idリストがある場合のみpage_idチェックを実行 | E-01 (72行目) | ○ |
| C-15 | apex_app_idが-99999の場合はNVL置換 | E-01 (63-64行目) | ○ |
| C-16 | qa_apex_blacklisted_apps_vビューの具体的な構造 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- qa_apex_blacklisted_apps_vビューの定義ファイルが見つからない
  - 候補：src/ddl/vw/qa_apex_blacklisted_apps_v.sql / src/plsql/vw/qa_apex_blacklisted_apps.sql

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本機能の主要なロジックはソースコードで確認できる
- 1: 中リスク - ブラックリストビューの構造が未確認のため、ブラックリスト登録方法の完全な理解には追加調査が必要

## 6) レビュアーチェックリスト（最小）
- [ ] p_exclude_not_whitelisted_apex_entriesのIN OUTパラメータが正しく記載されているか確認
- [ ] フィルタリングロジック（ブラックリスト、app_id、page_id）が正しいか確認
- [ ] qa_apex_blacklisted_apps_vビューの定義を確認し、必要に応じて設計書を更新
