---
generated_at: 2026-01-21 17:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-ダッシュボードデータ取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/plsql/pkg/qa_apex_app_pkg.sql` - APEX App パッケージ仕様部・本体
- E-02: `src/plsql/typ/qa_test_results_row_t.sql` - 戻り値行型定義
- E-03: `src/plsql/typ/qa_test_results_table_t.sql` - 戻り値テーブル型定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | get_faceted_search_dashboard_dataはパイプライン関数 | E-01 (63行目: PIPELINED) | ○ |
| C-02 | 入力パラメータはpi_page_idとpi_region_static_id | E-01 (19-23行目) | ○ |
| C-03 | 戻り値はqa_test_results_table_t | E-01 (23行目) | ○ |
| C-04 | qa_test_results_row_tは11属性を持つ | E-02 (14-24行目) | ○ |
| C-05 | APEX_APPLICATION_PAGE_REGIONSからリージョンIDを取得 | E-01 (80-85行目) | ○ |
| C-06 | apex_region.open_query_contextでコンテキストをオープン | E-01 (87-88行目) | ○ |
| C-07 | get_column_indexesで11カラムのインデックスを取得 | E-01 (90行目, 71-78行目) | ○ |
| C-08 | apex_exec.next_rowでループ | E-01 (92行目) | ○ |
| C-09 | PIPE ROWでqa_test_results_row_tを出力 | E-01 (93-104行目) | ○ |
| C-10 | apex_exec.closeでコンテキストをクローズ | E-01 (107行目) | ○ |
| C-11 | V('APP_ID')でAPEXアプリケーションIDを取得 | E-01 (83行目) | ○ |
| C-12 | NO_DATA_NEEDED例外を処理 | E-01 (109-111行目) | ○ |
| C-13 | OTHERS例外時もコンテキストをクローズ | E-01 (112-114行目) | ○ |
| C-14 | Dashboard画面と関連 | E-04 | ○ |
| C-15 | qa_test_results_table_tはqa_test_results_row_tのテーブル型 | E-03 (13行目) | ○ |
| C-16 | 取得カラムにQATR_ID、QATR_DATE等の11カラム | E-01 (90行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本機能の主要なロジックはソースコードで完全に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] get_faceted_search_dashboard_dataの入力パラメータと戻り値が正しく記載されているか確認
- [ ] qa_test_results_row_tの11属性がすべて正しく記載されているか確認
- [ ] APEX API（apex_region、apex_exec）の使用方法が正しく説明されているか確認
