---
generated_at: 2026-01-21 16:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-全ルール実行

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な数値の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_api_pkg.sql` - 全ルール実行関数
- E-02: `src/plsql/pkg/qa_main_pkg.sql` - ルール管理補助関数
- E-03: `src/plsql/typ/qa_running_rule_t.sql` - 実行中ルール型
- E-04: `src/plsql/vw/qa_predecessor_order_v.sql` - 先行ルール順序ビュー
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | tf_run_rules関数として実装 | E-01 (39-43行目, 154-275行目) | ○ |
| C-02 | 2つの入力パラメータ（クライアント名、対象スキーマ） | E-01 (39-43行目) | ○ |
| C-03 | pi_target_schemeのデフォルト値はUSER | E-01 (42行目) | ○ |
| C-04 | 必須パラメータのNULLチェック | E-01 (178-183行目) | ○ |
| C-05 | f_check_for_loopでループ検出 | E-01 (186-191行目), E-02 (899-960行目) | ○ |
| C-06 | ループ検出時はNULL返却 | E-01 (188-191行目) | ○ |
| C-07 | qa_running_rules_tで実行状態初期化 | E-01 (193-212行目) | ○ |
| C-08 | tf_get_rule_numbersで先行ルール順序取得 | E-01 (214行目), E-02 (493-531行目) | ○ |
| C-09 | qa_predecessor_order_vと結合してルール順序決定 | E-02 (509-515行目), E-04 | ○ |
| C-10 | 先行ルールの成功状態をカウント | E-01 (219-225行目) | ○ |
| C-11 | l_allowed_to_run=0で実行可能 | E-01 (228行目) | ○ |
| C-12 | tf_run_ruleで個別ルール実行 | E-01 (231-233行目) | ○ |
| C-13 | multiset unionで結果集約 | E-01 (235行目) | ○ |
| C-14 | 検出オブジェクト0件で成功（Y） | E-01 (237-242行目) | ○ |
| C-15 | 実行状態更新（success_run） | E-01 (244-249行目, 252-257行目) | ○ |
| C-16 | Region Plugin画面(No.12)の補助機能 | E-05 (31行目) | ○ |
| C-17 | qaru_is_active=1かつqaru_error_level<=4のみ対象 | E-02 (512-513行目) | ○ |
| C-18 | ORA-1436でループ検出例外 | E-02 (910-911行目, 946-952行目) | ○ |
| C-19 | authid current_userで実行 | E-01 (2行目) | ○ |
| C-20 | パフォーマンス要件：ルール数 * 数秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **パフォーマンス要件の根拠**
  - 理由：ソースコード・設計書に明示的な性能要件の記載がない
  - 候補：非機能要件定義書 / システム設計書 / 性能テスト結果

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 関数仕様、先行ルール依存処理はソースコードで明確に確認済み
- **1（中リスク）**: パフォーマンス要件は推測値のため、大量ルール環境で要検証
- **0（低リスク）**: ループ検出ロジックはソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] tf_run_rules関数の2つのパラメータが正しく記載されているか
- [ ] 先行ルール依存関係の処理フローが正確か
- [ ] success_runの状態遷移（NULL→Y/N）の説明が正確か
- [ ] コードリーディングガイドの行番号が現在のソースと一致しているか
- [ ] パフォーマンス要件の妥当性を確認
