---
generated_at: 2026-01-21 17:38:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-テスト結果XMLダウンロード

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/plsql/pkg/qa_apex_app_pkg.sql` - APEX App パッケージ仕様部・本体
- E-02: `src/plsql/pkg/qa_unit_tests_pkg.sql` - ユニットテストパッケージ
- E-03: `src/ddl/tab/qa_test_results.sql` - QA_TEST_RESULTSテーブル定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | p_download_unit_test_xmlはテスト結果XMLをダウンロードする | E-01 (248-295行目) | ○ |
| C-02 | 入力パラメータはpi_qatr_id | E-01 (47行目) | ○ |
| C-03 | f_export_test_resultを呼び出す | E-01 (264行目) | ○ |
| C-04 | qatr_added_onを取得してファイル名に使用 | E-01 (266-269行目, 276行目) | ○ |
| C-05 | HTP.initでHTTP出力を初期化 | E-01 (271行目) | ○ |
| C-06 | OWA_UTIL.mime_headerでMIMEタイプを設定 | E-01 (272行目) | ○ |
| C-07 | Content-Dispositionでファイル名を設定 | E-01 (276行目) | ○ |
| C-08 | チャンクサイズは3000バイト | E-01 (256行目) | ○ |
| C-09 | HTP.prnでチャンク出力 | E-01 (281行目) | ○ |
| C-10 | apex_application.stop_apex_engineを呼び出す | E-01 (285行目) | ○ |
| C-11 | e_stop_apex_engine例外を捕捉 | E-01 (287-288行目) | ○ |
| C-12 | Test Result Files画面と関連 | E-04 | ○ |
| C-13 | QA_TEST_RESULTSからqatr_xml_resultを取得 | E-02 (1473-1476行目) | ○ |
| C-14 | エラー時はqa_logger_pkgでログ記録 | E-01 (289-293行目) | ○ |
| C-15 | ファイル名にqatr_added_onのタイムスタンプを含む | E-01 (276行目) | ○ |
| C-16 | AUTHID DEFINERで定義 | E-02 (1行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 本機能の主要なロジックはソースコードで完全に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] p_download_unit_test_xmlの入力パラメータが正しく記載されているか確認
- [ ] HTTPレスポンスヘッダーの設定が正しいか確認
- [ ] f_export_test_resultとの連携が正しいか確認
