---
generated_at: 2026-01-21 17:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：31-ファセット検索コレクション生成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **C-15**：ダッシュボードページとの具体的な連携タイミング

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_apex_app_pkg.sql` - p_fill_faceted_search_collectionプロシージャ（297-315行目）
- E-02: `src/plsql/pkg/qa_apex_app_pkg.sql` - get_faceted_search_dashboard_data関数（59-115行目）
- E-03: `src/plsql/typ/qa_test_results_row_t.sql` - データ行型定義
- E-04: `src/plsql/typ/qa_test_results_table_t.sql` - データテーブル型定義
- E-05: `src/plsql/pkg/qa_logger_pkg.sql` - ロギングパッケージ
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コレクション名は「FACETED_SEARCH_DASHBOARD_DATA_P0001」で固定 | E-01（304行目） | ○ |
| C-02 | apex_collection.create_collection_from_queryを使用 | E-01（303-306行目） | ○ |
| C-03 | p_truncate_if_exists => 'YES'で既存コレクションを上書き | E-01（306行目） | ○ |
| C-04 | get_faceted_search_dashboard_data関数を内部で呼び出す | E-01（305行目） | ○ |
| C-05 | qa_logger_pkg.p_qa_logでエラーログを記録 | E-01（310-312行目） | ○ |
| C-06 | 入力パラメータはなし | E-01（297行目） | ○ |
| C-07 | qa_test_results_row_t型で11カラムを定義 | E-03（13-25行目） | ○ |
| C-08 | qa_test_results_table_tはqa_test_results_row_tのテーブル型 | E-04（13行目） | ○ |
| C-09 | APP_PAGE_IDセッション変数を使用 | E-01（305行目：nv('APP_PAGE_ID')） | ○ |
| C-10 | 例外発生時はraiseで例外を再スロー | E-01（314行目） | ○ |
| C-11 | Dashboard画面（画面No.2）と関連 | E-06（No.31の行） | ○ |
| C-12 | 機能カテゴリは「APEXフロントエンド」 | E-07（No.31の行） | ○ |
| C-13 | TESTレポートリージョンのデータを取得 | E-01（305行目：'TEST_REPORT'） | ○ |
| C-14 | APEXセッションコンテキスト内でのみ実行可能 | E-01（apex_collection APIの仕様） | ○ |
| C-15 | ページ読み込み時に自動実行される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ダッシュボードページの前処理（Before Header等）での呼び出し設定
  - 候補：APEXアプリケーションエクスポートファイル / ページ定義XML / APEXビルダー設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認可能な主張がほとんど
- 1: 中リスク - C-15のダッシュボードとの連携タイミングは実際のAPEX設定で確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] APEXアプリケーションのダッシュボードページで、p_fill_faceted_search_collectionの呼び出しタイミングを確認
- [ ] コレクションのデータ量が多い場合のパフォーマンステスト結果を確認
- [ ] APEXセッション外からの呼び出し時のエラーハンドリングを確認
