---
generated_at: 2026-01-21 17:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：32-パラメータログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_logger_pkg.sql` - パッケージ仕様部（1-257行目）
- E-02: `src/plsql/pkg/qa_logger_pkg.sql` - パッケージ本体（259-507行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | rec_param型はname/valの2フィールド構造 | E-01（18-20行目） | ○ |
| C-02 | tab_paramはrec_paramのINDEX BY BINARY_INTEGERテーブル | E-01（25行目） | ○ |
| C-03 | gc_date_formatは'DD-MON-YYYY HH24:MI:SS' | E-01（28行目） | ○ |
| C-04 | gc_timestamp_formatはgc_date_format || ':FF' | E-01（29行目） | ○ |
| C-05 | gc_timestamp_tz_formatはgc_timestamp_format || ' TZR' | E-01（30行目） | ○ |
| C-06 | 単一VARCHAR2版append_paramは336-347行目に実装 | E-02（336-347行目） | ○ |
| C-07 | パラメータ追加はp_params.count + 1の位置 | E-02（346行目） | ○ |
| C-08 | バルク版は最大14パラメータをサポート | E-01（92-123行目） | ○ |
| C-09 | バルク版は内部で単一版を14回呼び出す | E-02（384-425行目） | ○ |
| C-10 | NUMBER版はtocharで変換後VARCHAR2版を呼び出す | E-02（436-438行目） | ○ |
| C-11 | DATE版はtocharで変換後VARCHAR2版を呼び出す | E-02（449-451行目） | ○ |
| C-12 | BOOLEAN版はtocharでTRUE/FALSE/nullに変換 | E-02（329-332行目） | ○ |
| C-13 | p_paramsはIN OUT NOCOPY修飾子を使用 | E-01（55行目、94行目等） | ○ |
| C-14 | パッケージはAUTHID DEFINER | E-01（1行目） | ○ |
| C-15 | 機能カテゴリは「ロギング」 | E-03（No.32の行） | ○ |
| C-16 | 関数名はappend_param | E-01, E-02（複数箇所） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認可能な主張のみ

## 6) レビュアーチェックリスト（最小）
- [ ] バルク版でp_name_02以降がNULLの場合の挙動を確認（NULLパラメータも追加される）
- [ ] パラメータ値に機密情報が含まれる場合のマスキング方針を確認
- [ ] 大量パラメータ追加時のパフォーマンス影響を確認
