---
generated_at: 2026-01-21 17:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：33-エラーログ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_logger_pkg.sql` - p_qa_log仕様部（39-45行目）
- E-02: `src/plsql/pkg/qa_logger_pkg.sql` - p_qa_log本体（261-296行目）
- E-03: `src/scripts/install_constant_package.sql` - gc_logger_flag定数定義（46行目）
- E-04: `src/plsql/pkg/qa_apex_app_pkg.sql` - p_qa_log使用例（156-159行目）
- E-05: `src/plsql/pkg/qa_utils_pkg.sql` - p_qa_log使用例（144-147行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロシージャ名はp_qa_log | E-01（39行目） | ○ |
| C-02 | p_textはVARCHAR2型で必須 | E-01（41行目） | ○ |
| C-03 | p_scopeはVARCHAR2型でデフォルトNULL | E-01（42行目） | ○ |
| C-04 | p_extraはCLOB型でデフォルトNULL | E-01（43行目） | ○ |
| C-05 | p_paramsはtab_param型でデフォルトgc_empty_tab_param | E-01（44行目） | ○ |
| C-06 | gc_logger_flag = 1で条件付きコンパイル | E-02（268行目、275行目） | ○ |
| C-07 | Logger有効時はlogger.tab_paramに変換 | E-02（270行目） | ○ |
| C-08 | パラメータループでlogger.append_paramを呼び出す | E-02（282-285行目） | ○ |
| C-09 | DBMS_OUTPUT.PUT_LINEでデバッグ出力 | E-02（281行目） | ○ |
| C-10 | logger.logプロシージャを呼び出す | E-02（289-292行目） | ○ |
| C-11 | Logger無効時はnull文のみ | E-02（293-295行目） | ○ |
| C-12 | NVL関数でNULLを空文字に変換 | E-02（284-285行目） | ○ |
| C-13 | パッケージはAUTHID DEFINER | E-01（1行目） | ○ |
| C-14 | 機能カテゴリは「ロギング」 | E-06（No.33の行） | ○ |
| C-15 | 使用例がqa_apex_app_pkg、qa_utils_pkgに存在 | E-04, E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認可能な主張のみ

## 6) レビュアーチェックリスト（最小）
- [ ] Oracle Loggerがインストールされていない環境での動作確認
- [ ] gc_logger_flag = 0の場合のパフォーマンス影響確認
- [ ] LOGGER_LOGSテーブルへのアクセス権限設定の確認
