---
generated_at: 2026-01-21 17:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-型変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_logger_pkg.sql` - フォーマット定数定義（28-30行目）
- E-02: `src/plsql/pkg/qa_logger_pkg.sql` - tochar関数仕様部（208-255行目）
- E-03: `src/plsql/pkg/qa_logger_pkg.sql` - tochar関数本体（299-332行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | gc_date_formatは'DD-MON-YYYY HH24:MI:SS' | E-01（28行目） | ○ |
| C-02 | gc_timestamp_formatはgc_date_format || ':FF' | E-01（29行目） | ○ |
| C-03 | gc_timestamp_tz_formatはgc_timestamp_format || ' TZR' | E-01（30行目） | ○ |
| C-04 | NUMBER版はTO_CHAR(p_val)を使用 | E-03（301行目） | ○ |
| C-05 | DATE版はgc_date_formatを使用 | E-03（306-307行目） | ○ |
| C-06 | TIMESTAMP版はgc_timestamp_formatを使用 | E-03（312-313行目） | ○ |
| C-07 | TIMESTAMP WITH TZ版はgc_timestamp_tz_formatを使用 | E-03（318-319行目） | ○ |
| C-08 | TIMESTAMP WITH LOCAL TZ版はgc_timestamp_tz_formatを使用 | E-03（324-325行目） | ○ |
| C-09 | BOOLEAN版はCASE式でTRUE/FALSE/nullを返却 | E-03（331行目） | ○ |
| C-10 | 6種類のオーバーロードが存在 | E-02（複数箇所） | ○ |
| C-11 | 関数名はtochar | E-02, E-03（複数箇所） | ○ |
| C-12 | 戻り値はVARCHAR2型 | E-02（210, 219, 228, 237, 246, 255行目） | ○ |
| C-13 | 機能カテゴリは「ロギング」 | E-04（No.34の行） | ○ |
| C-14 | append_paramからtocharが呼び出される | E-03（438, 451行目等） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認可能な主張のみ

## 6) レビュアーチェックリスト（最小）
- [ ] NLS設定によるDATE/TIMESTAMPフォーマットへの影響を確認
- [ ] NUMBER型の変換精度（小数点以下桁数等）を確認
- [ ] BOOLEAN型のNULL値の扱いが呼び出し元で問題ないことを確認
