---
generated_at: 2026-01-21 18:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-文字列統一化

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_utils_pkg.sql` - f_get_unified_string仕様部（44-51行目）
- E-02: `src/plsql/pkg/qa_utils_pkg.sql` - f_get_unified_string本体（191-244行目）
- E-03: `src/plsql/pkg/qa_apex_app_pkg.sql` - 使用例（181行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 関数名はf_get_unified_string | E-01（44行目） | ○ |
| C-02 | pi_regexpのデフォルト値は'[^a-zA-Z0-9_]' | E-01（47行目） | ○ |
| C-03 | pi_replace_blank_spaceのデフォルト値は'Y' | E-01（48行目） | ○ |
| C-04 | pi_replacement_charのデフォルト値は'_' | E-01（49行目） | ○ |
| C-05 | pi_transform_caseのデフォルト値はNULL | E-01（50行目） | ○ |
| C-06 | DETERMINISTIC修飾子が付与されている | E-01（51行目） | ○ |
| C-07 | 入力妥当性チェックで-20001エラーを発生 | E-02（216-220行目） | ○ |
| C-08 | スペース置換はpi_replace_blank_space = 'Y'時に実行 | E-02（222-224行目） | ○ |
| C-09 | REGEXP_REPLACEで正規表現置換を実行 | E-02（222行目） | ○ |
| C-10 | pi_transform_case = 'l'で小文字変換 | E-02（228-230行目） | ○ |
| C-11 | pi_transform_case = 'u'で大文字変換 | E-02（231-233行目） | ○ |
| C-12 | 例外発生時はqa_logger_pkg.p_qa_logでログ記録 | E-02（239-242行目） | ○ |
| C-13 | 例外発生時はraiseで例外を再スロー | E-02（243行目） | ○ |
| C-14 | p_download_rules_jsonで使用されている | E-03（181行目） | ○ |
| C-15 | 機能カテゴリは「ユーティリティ」 | E-04（No.37の行） | ○ |
| C-16 | pi_replace_blank_spaceは'Y'または'N'のみ許可 | E-02（216行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認可能な主張のみ

## 6) レビュアーチェックリスト（最小）
- [ ] 正規表現パターンに特殊文字を含む場合のエスケープ処理を確認
- [ ] 連続する置換文字の扱い（圧縮されない）が許容可能か確認
- [ ] マルチバイト文字（日本語等）を入力した場合の挙動を確認
