---
generated_at: 2026-01-21 18:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-文字列置換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_utils_pkg.sql` - f_replace_string仕様部（61-66行目）
- E-02: `src/plsql/pkg/qa_utils_pkg.sql` - f_replace_string本体（246-296行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 関数名はf_replace_string | E-01（61行目） | ○ |
| C-02 | pi_source_stringはCLOB型 | E-01（63行目） | ○ |
| C-03 | pi_search_stringはVARCHAR2型 | E-01（64行目） | ○ |
| C-04 | pi_replace_stringはCLOB型 | E-01（65行目） | ○ |
| C-05 | 戻り値はCLOB型 | E-01（66行目） | ○ |
| C-06 | DETERMINISTIC修飾子が付与されている | E-01（66行目） | ○ |
| C-07 | DBMS_LOB.SUBSTRで先頭4000文字を切り出し | E-02（260-261行目） | ○ |
| C-08 | INSTR関数で検索位置を特定 | E-02（272-273行目） | ○ |
| C-09 | l_pos > 0の場合に置換処理を実行 | E-02（274行目） | ○ |
| C-10 | SUBSTR関数で文字列を分割・連結 | E-02（276-279行目） | ○ |
| C-11 | 検索失敗時は元文字列を返却 | E-02（282行目） | ○ |
| C-12 | NO_DATA_FOUND例外を処理 | E-02（284-289行目） | ○ |
| C-13 | OTHERS例外を処理 | E-02（290-295行目） | ○ |
| C-14 | 機能カテゴリは「ユーティリティ」 | E-03（No.38の行） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認可能な主張のみ

## 6) レビュアーチェックリスト（最小）
- [ ] 最初の出現のみ置換される仕様が要件を満たしているか確認
- [ ] 大きなCLOB（数MB以上）での性能を確認
- [ ] 検索文字列がCLOBの末尾にある場合の挙動を確認
