---
generated_at: 2026-01-21 18:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-DBMS出力

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_utils_pkg.sql` - VARCHAR2版仕様部（73-76行目）
- E-02: `src/plsql/pkg/qa_utils_pkg.sql` - CLOB版仕様部（83-86行目）
- E-03: `src/plsql/pkg/qa_utils_pkg.sql` - VARCHAR2版本体（298-324行目）
- E-04: `src/plsql/pkg/qa_utils_pkg.sql` - CLOB版本体（326-365行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プロシージャ名はp_print_to_dbms_output | E-01（73行目）, E-02（83行目） | ○ |
| C-02 | VARCHAR2版とCLOB版の2つのオーバーロードが存在 | E-01, E-02 | ○ |
| C-03 | VARCHAR2版はDBMS_OUTPUT.PUT_LINEを直接呼び出す | E-03（310行目） | ○ |
| C-04 | CLOB版のl_offsetの初期値は1 | E-04（334行目） | ○ |
| C-05 | CLOB版のl_stepは32767 | E-04（335行目） | ○ |
| C-06 | CLOB版でDBMS_OUTPUT.ENABLEを呼び出す | E-04（344行目） | ○ |
| C-07 | バッファサイズは10000000（10MB） | E-04（344行目） | ○ |
| C-08 | CLOB版でDBMS_LOB.GETLENGTHを使用 | E-04（346行目） | ○ |
| C-09 | CLOB版でDBMS_LOB.SUBSTRを使用 | E-04（347-348行目） | ○ |
| C-10 | ループでl_offsetを増加させる | E-04（350行目） | ○ |
| C-11 | DETERMINISTIC修飾子が付与されている | E-01（76行目）, E-02（86行目） | ○ |
| C-12 | NO_DATA_FOUND例外を処理 | E-03（312-317行目）, E-04（353-358行目） | ○ |
| C-13 | OTHERS例外を処理 | E-03（318-323行目）, E-04（359-364行目） | ○ |
| C-14 | 機能カテゴリは「ユーティリティ」 | E-05（No.39の行） | ○ |
| C-15 | CLOB版でログ用に先頭4000文字を切り出し | E-04（339行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認可能な主張のみ

## 6) レビュアーチェックリスト（最小）
- [ ] 10MB以上のCLOBを出力した場合のバッファオーバーフローを確認
- [ ] マルチバイト文字（日本語等）を含むCLOBの分割位置が適切か確認
- [ ] SET SERVEROUTPUT ONが設定されていない環境での挙動を確認
