---
generated_at: 2026-01-21 16:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-ルール有効無効制御

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/ddl/tab/qa_rules.sql` - QA_RULESテーブル定義
- E-02: `src/plsql/pkg/qa_main_pkg.sql` - ルール管理パッケージ
- E-03: `src/plsql/pkg/qa_api_pkg.sql` - ルール実行API
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | qaru_is_active列で有効/無効を制御 | E-01 (16行目), E-05 | ○ |
| C-02 | qaru_is_active=0で無効、1で有効 | E-01 (51行目コメント) | ○ |
| C-03 | デフォルト値は1（有効） | E-01 (16行目: default 1) | ○ |
| C-04 | NOT NULL制約あり | E-01 (16行目: not null) | ○ |
| C-05 | f_is_rule_active関数で有効性確認 | E-02 (46-50行目, 290-326行目) | ○ |
| C-06 | 戻り値はBOOLEAN型 | E-02 (50行目) | ○ |
| C-07 | qaru_is_active=0でFALSE返却 | E-02 (313-315行目) | ○ |
| C-08 | qaru_is_active!=0でTRUE返却 | E-02 (316-318行目) | ○ |
| C-09 | tf_run_ruleでf_is_rule_activeを呼び出し | E-03 (85-86行目) | ○ |
| C-10 | 無効ルール実行時にエラー発生 | E-03 (87-91行目) | ○ |
| C-11 | tf_get_rule_numbersでqaru_is_active=1のみ取得 | E-02 (512行目) | ○ |
| C-12 | Rules画面(No.7)でアクティブ状態表示 | E-04 (15行目) | ○ |
| C-13 | Add/Edit Rule画面(No.8)でYes/No設定 | E-04 (19行目) | ○ |
| C-14 | パラメータをログ記録 | E-02 (301-305行目) | ○ |
| C-15 | エラー時はログ記録して再スロー | E-02 (320-325行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで明確に確認済み
- **0（低リスク）**: 画面連携は画面機能マッピングで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] qaru_is_active列の定義（デフォルト1、NOT NULL）が正しく記載されているか
- [ ] f_is_rule_active関数の戻り値ロジック（0→FALSE, 他→TRUE）が正確か
- [ ] コードリーディングガイドの行番号が現在のソースと一致しているか
