---
generated_at: 2026-01-21 18:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-定数値取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_utils_pkg.sql` - f_get_constant_string_value仕様部（94-96行目）
- E-02: `src/plsql/pkg/qa_utils_pkg.sql` - f_get_constant_number_value仕様部（104-106行目）
- E-03: `src/plsql/pkg/qa_utils_pkg.sql` - f_get_constant_string_value本体（367-410行目）
- E-04: `src/plsql/pkg/qa_utils_pkg.sql` - f_get_constant_number_value本体（412-457行目）
- E-05: `src/scripts/install_constant_package.sql` - qa_constant_pkg定義（25-61行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | f_get_constant_string_valueはVARCHAR2を返す | E-01（96行目） | ○ |
| C-02 | f_get_constant_number_valueはNUMBERを返す | E-02（106行目） | ○ |
| C-03 | UPPER(pi_constant_name)で大文字に変換して比較 | E-03（382行目）, E-04（427行目） | ○ |
| C-04 | gc_quasto_nameが取得可能 | E-03（384行目） | ○ |
| C-05 | gc_quasto_versionが取得可能 | E-03（385行目） | ○ |
| C-06 | gc_utplsql_flagが取得可能 | E-04（429行目） | ○ |
| C-07 | gc_apex_flagが取得可能 | E-04（430行目） | ○ |
| C-08 | gc_logger_flagが取得可能 | E-04（431行目） | ○ |
| C-09 | e_constant_not_foundカスタム例外を定義 | E-03（373-374行目）, E-04（418-419行目） | ○ |
| C-10 | 存在しない定数名で-20001エラーを発生 | E-03（402-403行目）, E-04（449-450行目） | ○ |
| C-11 | gc_invalid_constant_exception_textを使用 | E-03（403行目）, E-04（450行目） | ○ |
| C-12 | qa_constant_pkgはinstall_constant_package.sqlで生成 | E-05（25-61行目） | ○ |
| C-13 | gc_utplsql_scheme_result_*定数が取得可能 | E-04（436-438行目） | ○ |
| C-14 | gc_utplsql_*プレフィックス定数が取得可能 | E-03（389-391行目） | ○ |
| C-15 | 機能カテゴリは「ユーティリティ」 | E-06（No.40の行） | ○ |
| C-16 | OTHERS例外を処理 | E-03（404-409行目）, E-04（451-456行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードベースから直接確認可能な主張のみ

## 6) レビュアーチェックリスト（最小）
- [ ] qa_constant_pkgに新しい定数を追加した際、本関数への反映漏れがないか確認
- [ ] 取得可能な定数一覧がドキュメントと実装で一致しているか確認
- [ ] エラーメッセージが適切にローカライズされているか確認
