---
generated_at: 2026-01-21 16:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：41-ブラックリスト判定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **gc_black_list_exception_text定数の実定義**：qa_constant_pkgの実ファイル未確認
  2. **画面との関連**：画面機能マッピングCSVに直接記載なし
  3. **パフォーマンス要件**：推定値のため検証必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_main_pkg.sql` - f_is_owner_black_listed関数（1006-1056行目）
- E-02: `src/plsql/vw/qa_scheme_names_for_testing_v.sql` - ビュー定義（1-80行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.41の定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 関数名がf_is_owner_black_listedである | E-01 (1006行目) | ○ |
| C-02 | 入力パラメータはpi_user_name(VARCHAR2)である | E-01 (1006行目) | ○ |
| C-03 | 戻り値はBOOLEAN型である | E-01 (1006行目) | ○ |
| C-04 | NULLの場合はFALSEを返却する | E-01 (1039-1041行目) | ○ |
| C-05 | qa_scheme_names_for_testing_vビューと照合する | E-01 (1024-1027行目), E-02 | ○ |
| C-06 | 大文字変換して比較する | E-01 (1027行目: upper(v.username) = upper(pi_user_name)) | ○ |
| C-07 | カウント0でブラックリストと判定 | E-01 (1029-1035行目) | ○ |
| C-08 | e_user_blacklisted例外を発生させる | E-01 (1013-1015, 1032行目) | ○ |
| C-09 | -20007エラーコードを返却 | E-01 (1044行目) | ○ |
| C-10 | 70以上のシステムスキーマが除外対象 | E-02 (4-77行目のNOT IN句) | ○ |
| C-11 | APEX_nnnn00形式のスキーマを正規表現で除外 | E-02 (79行目) | ○ |
| C-12 | DEFINER権限で実行される | E-01 (1行目: authid definer) | ○ |
| C-13 | qa_logger_pkg.append_paramでログ記録 | E-01 (1018-1020行目) | ○ |
| C-14 | qa_logger_pkg.p_qa_logでエラーログ記録 | E-01 (1046-1049, 1051-1054行目) | ○ |
| C-15 | gc_black_list_exception_textを参照 | E-01 (1045行目) | ○ |
| C-16 | gc_black_list_exception_textの実定義内容 | **根拠なし** | △ |
| C-17 | 機能カテゴリがスキーマ管理である | E-03 | ○ |
| C-18 | ALL_USERSデータディクショナリを参照 | E-02 (2行目: from all_users) | ○ |

## 4) 不足情報（Unknown / Missing）
- qa_constant_pkg.sqlの実ファイル内容が未確認のため、gc_black_list_exception_textの実際の文字列値が不明
  - 候補：エラーメッセージテンプレート / ユーザー通知用文言

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要なロジックはソースコードから完全に確認済み
- 1: 中リスク - 定数定義の詳細内容（エラーメッセージ文言）

## 6) レビュアーチェックリスト（最小）
- [ ] f_is_owner_black_listed関数のスペックとボディの整合性を確認
- [ ] qa_scheme_names_for_testing_vのブラックリストスキーマ一覧が最新か確認
- [ ] gc_black_list_exception_textの実際の文字列値を確認
- [ ] 例外コード-20006と-20007の使い分けが適切か確認
