---
generated_at: 2026-01-21 16:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-ルール格納

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **シーケンス定義**：別途シーケンス/トリガ定義の確認が必要
  2. **インデックス定義**：ind/qa_rules.sqlの詳細確認
  3. **参照整合性**：QA_TEST_RUNSからの外部キー参照

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/ddl/tab/qa_rules.sql` - テーブル定義（1-79行目）
- E-02: `src/ddl/cons/qa_rules.sql` - 制約定義（1-130行目）
- E-03: `src/plsql/pkg/qa_main_pkg.sql` - f_insert_rule関数（749-838行目）
- E-04: `src/plsql/pkg/qa_main_pkg.sql` - f_get_rule関数（213-256行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.42の定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブル名がQA_RULESである | E-01 (4行目) | ○ |
| C-02 | 21列で構成される | E-01 (6-26行目で21列定義) | ○ |
| C-03 | QARU_IDが主キーである | E-02 (11行目) | ○ |
| C-04 | QARU_CATEGORYのCHECK制約が'APEX','DDL','DATA' | E-02 (31行目) | ○ |
| C-05 | QARU_ERROR_LEVELのCHECK制約が1,2,4 | E-02 (51行目) | ○ |
| C-06 | QARU_IS_ACTIVEのCHECK制約が0,1 | E-02 (71行目) | ○ |
| C-07 | QARU_LAYERのCHECK制約が'PAGE','APPLICATION','DATABASE' | E-02 (111行目) | ○ |
| C-08 | QARU_SQLの長さ制約が32767文字以下 | E-02 (91行目) | ○ |
| C-09 | QARU_IS_ACTIVEのデフォルト値が1 | E-01 (16行目: default 1) | ○ |
| C-10 | QARU_SQLはCLOB型である | E-01 (17行目) | ○ |
| C-11 | テーブルコメントが定義されている | E-01 (40行目) | ○ |
| C-12 | 列コメントが21列分定義されている | E-01 (41-60行目) | ○ |
| C-13 | f_insert_rule関数が存在する | E-03 (151-166行目スペック) | ○ |
| C-14 | f_insert_rule関数がINSERT文を実行する | E-03 (800-828行目) | ○ |
| C-15 | f_insert_rule関数がQARU_IDを返却する | E-03 (828行目: returning qaru_id) | ○ |
| C-16 | f_get_rule関数がqa_rule_t型を返却する | E-04 (217行目) | ○ |
| C-17 | QARU_CLIENT_NAMEがVARCHAR2(100 CHAR) | E-01 (8行目) | ○ |
| C-18 | QARU_ERROR_MESSAGEがVARCHAR2(4000 CHAR) | E-01 (12行目) | ○ |
| C-19 | QARU_PREDECESSOR_IDSがコロン区切り | E-01 (53行目コメント) | ○ |
| C-20 | QARU_EXCLUDE_OBJECTSがコロン区切り | E-01 (49行目コメント) | ○ |
| C-21 | 監査列（CREATED_ON/BY, UPDATED_ON/BY）が定義されている | E-01 (20-23行目) | ○ |
| C-22 | APEX用のAPP_ID, PAGE_IDフィルタ列がある | E-01 (25-26行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- シーケンス定義ファイルが未確認（QARU_IDの自動採番方法）
- トリガ定義ファイルが未確認（監査列の自動更新方法）
  - 候補：`src/ddl/trg/` ディレクトリ / APEXトリガ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル定義とCRUD操作はソースコードから完全に確認済み
- 0: 低リスク - 制約定義もすべて確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] シーケンス定義（QARU_ID用）の存在を確認
- [ ] トリガ定義（監査列自動更新用）の存在を確認
- [ ] インデックス定義の詳細を確認
- [ ] QA_TEST_RUNSからの外部キー参照の影響を確認
- [ ] ルール数の上限や運用想定を確認
