---
generated_at: 2026-01-21 17:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：44-テスト結果XML格納

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **UNIQUE制約の運用影響**：同時刻テスト実行時の挙動確認
  2. **XMLサイズ上限**：CLOB格納の実運用での制限確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/ddl/tab/qa_test_results.sql` - テーブル定義（1-49行目）
- E-02: `src/ddl/cons/qa_test_results.sql` - 制約定義（1-50行目）
- E-03: `src/plsql/pkg/qa_unit_tests_pkg.sql` - f_run_all_unit_tests（976-977行目）
- E-04: `src/plsql/pkg/qa_unit_tests_pkg.sql` - f_import_test_result（1446-1448行目）
- E-05: `src/plsql/pkg/qa_unit_tests_pkg.sql` - f_export_test_result（1473-1476行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.44の定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブル名がQA_TEST_RESULTSである | E-01 (4行目) | ○ |
| C-02 | 5列で構成される | E-01 (6-10行目で5列定義) | ○ |
| C-03 | QATR_IDが主キーである | E-02 (11行目) | ○ |
| C-04 | QATR_ADDED_ONにUNIQUE制約がある | E-02 (31行目) | ○ |
| C-05 | QATR_XML_RESULTがCLOB型である | E-01 (7行目) | ○ |
| C-06 | QATR_DESCRIPTIONがVARCHAR2(255 CHAR) | E-01 (10行目) | ○ |
| C-07 | f_run_all_unit_testsでINSERTが実行される | E-03 (976-977行目) | ○ |
| C-08 | DESCRIPTIONに'Executed by Suite Path:'が設定される | E-03 (977行目) | ○ |
| C-09 | f_import_test_resultでインポートINSERTが実行される | E-04 (1446-1448行目) | ○ |
| C-10 | インポート時のDESCRIPTIONは'Imported by User' | E-04 (1447行目) | ○ |
| C-11 | f_export_test_resultでXMLがSELECTされる | E-05 (1473-1476行目) | ○ |
| C-12 | テーブルコメントが定義されている | E-01 (24行目) | ○ |
| C-13 | 列コメントが5列分定義されている | E-01 (25-29行目) | ○ |
| C-14 | utPLSQL ut.run()でテスト実行される | E-03 (971-973行目) | ○ |
| C-15 | ut_junit_reporter()でXMLが生成される | E-03 (973行目) | ○ |
| C-16 | Dashboard画面で結果が参照される | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル定義と操作関数はソースコードから完全に確認済み
- 1: 中リスク - QATR_ADDED_ONのUNIQUE制約により同時刻テスト実行時にエラーの可能性

## 6) レビュアーチェックリスト（最小）
- [ ] UNIQUE制約（QATR_ADDED_ON）の同時実行時の挙動を確認
- [ ] シーケンス定義（QATR_ID用）の存在を確認
- [ ] XMLサイズの上限と運用ルールを確認
- [ ] 履歴保持期間のポリシーを確認
