---
generated_at: 2026-01-21 17:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-テスト実行履歴格納

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **参照整合性の運用影響**：QA_RULES削除時の挙動確認
  2. **履歴保持ポリシー**：データ増加時の対応方針

## 2) 参照した情報（Evidence一覧）

- E-01: `src/ddl/tab/qa_test_runs.sql` - テーブル定義（1-55行目）
- E-02: `src/ddl/cons/qa_test_runs.sql` - 制約定義（1-70行目）
- E-03: `src/plsql/pkg/qa_unit_tests_pkg.sql` - f_save_scheme_result（1038-1060行目）
- E-04: `src/plsql/pkg/qa_unit_tests_pkg.sql` - p_handle_test_result（1072-1141行目）
- E-05: `src/plsql/pkg/qa_unit_tests_pkg.sql` - p_handle_test_exception（1143-1168行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.45の定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブル名がQA_TEST_RUNSである | E-01 (4行目) | ○ |
| C-02 | 8列で構成される | E-01 (6-13行目で8列定義) | ○ |
| C-03 | QATR_IDが主キーである | E-02 (11行目: QATRU_PK) | ○ |
| C-04 | QATR_RESULTのCHECK制約が0,1,2 | E-02 (51行目) | ○ |
| C-05 | QATR_QARU_IDがQA_RULESへの外部キー | E-02 (31行目) | ○ |
| C-06 | QATR_SCHEME_NAMEがVARCHAR2(255 CHAR) | E-01 (7行目) | ○ |
| C-07 | QATR_RUNTIME_ERRORがVARCHAR2(4000 CHAR) | E-01 (12行目) | ○ |
| C-08 | f_save_scheme_resultでINSERTが実行される | E-03 (1055-1057行目) | ○ |
| C-09 | 結果コードの検証がある | E-03 (1047-1053行目) | ○ |
| C-10 | p_handle_test_resultでf_save_scheme_resultが呼ばれる | E-04 (1110-1113, 1116-1119行目) | ○ |
| C-11 | p_handle_test_exceptionでエラー結果が保存される | E-05 (1160-1163行目) | ○ |
| C-12 | p_handle_test_exceptionでRUNTIME_ERRORが更新される | E-05 (1164-1166行目) | ○ |
| C-13 | AUTONOMOUS_TRANSACTIONで実行される | E-04 (1081行目), E-05 (1151行目) | ○ |
| C-14 | テーブルコメントが定義されている | E-01 (27行目) | ○ |
| C-15 | 列コメントが8列分定義されている | E-01 (28-35行目) | ○ |
| C-16 | 定数gc_utplsql_scheme_result_successが使用される | E-04 (1113行目) | ○ |
| C-17 | 定数gc_utplsql_scheme_result_failureが使用される | E-04 (1119行目) | ○ |
| C-18 | 定数gc_utplsql_scheme_result_errorが使用される | E-05 (1163行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル定義と操作関数はソースコードから完全に確認済み
- 1: 中リスク - QA_RULESへの外部キーにより、ルール削除時に参照整合性エラーが発生する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 外部キー（QATR_QARU_ID）のカスケード削除設定を確認
- [ ] シーケンス定義（QATR_ID用）の存在を確認
- [ ] 履歴データの保持期間ポリシーを確認
- [ ] インデックス定義（QATR_DATE, QATR_QARU_ID）を確認
