---
generated_at: 2026-01-21 17:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-無効オブジェクト格納

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **カスケード削除設定**：親テーブル削除時の挙動確認
  2. **データ量見積もり**：大量失敗時のパフォーマンス確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/ddl/tab/qa_test_run_invalid_objects.sql` - テーブル定義（1-47行目）
- E-02: `src/ddl/cons/qa_test_run_invalid_objects.sql` - 制約定義（1-50行目）
- E-03: `src/plsql/pkg/qa_unit_tests_pkg.sql` - p_save_scheme_faulty_objects（1062-1070行目）
- E-04: `src/plsql/pkg/qa_unit_tests_pkg.sql` - p_handle_test_result（1122-1134行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.46の定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | テーブル名がQA_TEST_RUN_INVALID_OBJECTSである | E-01 (4行目) | ○ |
| C-02 | 4列で構成される | E-01 (6-9行目で4列定義) | ○ |
| C-03 | QATO_IDが主キーである | E-02 (11行目: QATO_PK) | ○ |
| C-04 | QATO_QATR_IDがQA_TEST_RUNSへの外部キー | E-02 (31行目) | ○ |
| C-05 | QATO_OBJECT_NAMEがVARCHAR2(4000 CHAR) | E-01 (7行目) | ○ |
| C-06 | QATO_OBJECT_DETAILSがVARCHAR2(4000 CHAR) | E-01 (8行目) | ○ |
| C-07 | p_save_scheme_faulty_objectsでINSERTが実行される | E-03 (1068-1069行目) | ○ |
| C-08 | p_handle_test_resultからp_save_scheme_faulty_objectsが呼ばれる | E-04 (1130-1132行目) | ○ |
| C-09 | テーブルコメントが定義されている | E-01 (23行目) | ○ |
| C-10 | 列コメントが4列分定義されている | E-01 (24-27行目) | ○ |
| C-11 | Invalid Objects画面で参照される | E-06 | ○ |
| C-12 | 全列がNOT NULL制約を持つ | E-01 (6-9行目) | ○ |
| C-13 | 失敗スキーマのループ内で呼び出される | E-04 (1122-1134行目) | ○ |
| C-14 | 無効オブジェクトごとにINSERTされる | E-04 (1122-1134行目のループ構造) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル定義と操作関数はソースコードから完全に確認済み
- 1: 中リスク - 親テーブル（QA_TEST_RUNS）削除時のカスケード挙動

## 6) レビュアーチェックリスト（最小）
- [ ] 外部キー（QATO_QATR_ID）のカスケード削除設定を確認
- [ ] シーケンス定義（QATO_ID用）の存在を確認
- [ ] 大量失敗時のパフォーマンス影響を確認
- [ ] インデックス定義（QATO_QATR_ID）を確認
