---
generated_at: 2026-01-21 17:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：47-ルール型定義

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **to_stringメンバー関数**：未実装の理由と将来計画確認
  2. **FORCE句の影響**：依存オブジェクトへの影響確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/plsql/typ/qa_rule_t.sql` - オブジェクト型定義（1-227行目）
- E-02: `src/plsql/typ/qa_rules_t.sql` - テーブル型定義（1-16行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.47の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 型名がqa_rule_tである | E-01 (1行目) | ○ |
| C-02 | 型名がqa_rules_tである | E-02 (1行目) | ○ |
| C-03 | qa_rules_tはTABLE OF qa_rule_tである | E-02 (13行目) | ○ |
| C-04 | qaru_id属性がNUMBER型 | E-01 (17行目) | ○ |
| C-05 | qaru_category属性がVARCHAR2(10) | E-01 (20行目) | ○ |
| C-06 | qaru_error_message属性がVARCHAR2(4000) | E-01 (22行目) | ○ |
| C-07 | qaru_sql属性がCLOB型 | E-01 (24行目) | ○ |
| C-08 | scheme_name属性がVARCHAR2(100) | E-01 (27行目) | ○ |
| C-09 | object_name属性がVARCHAR2(1000) | E-01 (29行目) | ○ |
| C-10 | object_details属性がVARCHAR2(2000) | E-01 (30行目) | ○ |
| C-11 | apex_app_id属性がNUMBER型 | E-01 (37行目) | ○ |
| C-12 | 4種類のコンストラクタがある | E-01 (41-99行目) | ○ |
| C-13 | 最小属性コンストラクタが存在 | E-01 (41-49行目) | ○ |
| C-14 | DBオブジェクト用コンストラクタが存在 | E-01 (51-68行目) | ○ |
| C-15 | ユニットテスト用コンストラクタが存在 | E-01 (70-77行目) | ○ |
| C-16 | APEXルール用コンストラクタが存在 | E-01 (79-99行目) | ○ |
| C-17 | to_stringメンバー関数がある | E-01 (101行目) | ○ |
| C-18 | to_stringは空文字列を返却 | E-01 (220-222行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 型定義はソースコードから完全に確認済み
- 0: 低リスク - 使用箇所も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] FORCE句による再作成時の依存オブジェクト影響を確認
- [ ] to_stringメンバー関数の実装予定を確認
- [ ] 属性追加時の下位互換性を確認
- [ ] コンストラクタのパラメータ順序を確認
