---
generated_at: 2026-01-21 17:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-実行中ルール型定義

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  1. **使用箇所の詳細**：qa_main_pkg内での具体的な使用パターン確認
  2. **predecessorの形式**：コロン区切りの詳細仕様確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/plsql/typ/qa_running_rule_t.sql` - オブジェクト型定義（1-22行目）
- E-02: `src/plsql/typ/qa_running_rules_t.sql` - テーブル型定義（1-16行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.48の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 型名がqa_running_rule_tである | E-01 (1行目) | ○ |
| C-02 | 型名がqa_running_rules_tである | E-02 (1行目) | ○ |
| C-03 | qa_running_rules_tはTABLE OF qa_running_rule_tである | E-02 (13行目) | ○ |
| C-04 | rule_number属性がVARCHAR2(10) | E-01 (15行目) | ○ |
| C-05 | predecessor属性がVARCHAR2(100) | E-01 (16行目) | ○ |
| C-06 | success_run属性がVARCHAR2(1) | E-01 (17行目) | ○ |
| C-07 | row_val属性がNUMBER型 | E-01 (18行目) | ○ |
| C-08 | 4属性で構成される | E-01 (15-18行目) | ○ |
| C-09 | コンストラクタは定義されていない | E-01（全体を確認、constructor function未定義） | ○ |
| C-10 | 2023年11月にsprangにより追加 | E-01 (10行目), E-02 (10行目) | ○ |
| C-11 | Release 23.2で追加 | E-01 (10行目), E-02 (10行目) | ○ |
| C-12 | FORCE句で作成される | E-01 (1行目: force) | ○ |

## 4) 不足情報（Unknown / Missing）
- qa_main_pkg内での具体的な使用箇所（依存関係解析ロジック）
  - 候補：p_test_rule / 内部関数

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 型定義はソースコードから完全に確認済み
- 1: 中リスク - 使用箇所の詳細は別途確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] predecessorのコロン区切り形式の仕様を確認
- [ ] success_runの値（Y/N）の扱いを確認
- [ ] 依存関係解析のアルゴリズムを確認
- [ ] 循環依存の検出ロジックを確認
