---
generated_at: 2026-01-21 17:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-スキーマオブジェクト量型定義

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **集計ロジック**：qa_main_pkg内での集計処理の詳細確認
  2. **成功/失敗判定**：object_amount=0の扱いの詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/plsql/typ/qa_scheme_object_amount_t.sql` - オブジェクト型定義（1-43行目）
- E-02: `src/plsql/typ/qa_scheme_object_amounts_t.sql` - テーブル型定義（1-16行目）
- E-03: `src/plsql/pkg/qa_unit_tests_pkg.sql` - p_handle_test_result（1072-1141行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.49の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 型名がqa_scheme_object_amount_tである | E-01 (1行目) | ○ |
| C-02 | 型名がqa_scheme_object_amounts_tである | E-02 (1行目) | ○ |
| C-03 | qa_scheme_object_amounts_tはTABLE OF qa_scheme_object_amount_tである | E-02 (13行目) | ○ |
| C-04 | scheme_name属性がVARCHAR2(100) | E-01 (15行目) | ○ |
| C-05 | object_amount属性がNUMBER型 | E-01 (16行目) | ○ |
| C-06 | 2属性で構成される | E-01 (15-16行目) | ○ |
| C-07 | コンストラクタが1つ定義されている | E-01 (18-23行目) | ○ |
| C-08 | コンストラクタはpi_scheme_name, pi_object_amountを受け取る | E-01 (20-22行目) | ○ |
| C-09 | 2023年11月にmwilhelmにより追加 | E-01 (10行目), E-02 (10行目) | ○ |
| C-10 | Release 23.2で追加 | E-01 (10行目), E-02 (10行目) | ○ |
| C-11 | FORCE句で作成される | E-01 (1行目: force) | ○ |
| C-12 | p_handle_test_resultでpi_scheme_objectsとして使用 | E-03 (1075行目) | ○ |
| C-13 | object_amount=0で成功判定 | E-03 (1108行目) | ○ |
| C-14 | object_amount>0で失敗判定（else分岐） | E-03 (1115-1119行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 型定義はソースコードから完全に確認済み
- 0: 低リスク - 使用箇所も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] qa_main_pkg.p_test_ruleでの集計ロジックを確認
- [ ] object_amountの上限値を確認
- [ ] コンストラクタのNULLパラメータ挙動を確認
- [ ] FORCE句による再作成時の依存オブジェクト影響を確認
