---
generated_at: 2026-01-21 16:50:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-オブジェクト除外

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/ddl/tab/qa_rules.sql` - QA_RULESテーブル定義
- E-02: `src/plsql/pkg/qa_main_pkg.sql` - ルール管理パッケージ
- E-03: `src/plsql/pkg/qa_api_pkg.sql` - ルール実行API
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | qaru_exclude_objects列にコロン区切りでオブジェクト名を指定 | E-01 (49行目コメント), E-05 | ○ |
| C-02 | VARCHAR2(4000 CHAR)型 | E-01 (14行目) | ○ |
| C-03 | p_exclude_objectsプロシージャでフィルタリング | E-02 (172行目, 842-897行目) | ○ |
| C-04 | IN OUT NOCOPY修飾子 | E-02 (172行目) | ○ |
| C-05 | QA_RULESからqaru_exclude_objectsを取得 | E-02 (857-860行目) | ○ |
| C-06 | regexp_substrでコロン区切り分割 | E-02 (862-872行目) | ○ |
| C-07 | UPPER関数で大文字・小文字無視の比較 | E-02 (878行目) | ○ |
| C-08 | コレクション.DELETE(i)で削除 | E-02 (880行目) | ○ |
| C-09 | tf_run_ruleでp_exclude_objects呼び出し | E-03 (134行目) | ○ |
| C-10 | f_get_excluded_objectsにresult_cache修飾子 | E-02 (538行目) | ○ |
| C-11 | Add/Edit Rule画面(No.8)で設定 | E-04 (20行目) | ○ |
| C-12 | エラー時はログ記録（例外再スローしない） | E-02 (891-896行目) | ○ |
| C-13 | コレクション空の場合は処理スキップ | E-02 (851-853行目) | ○ |
| C-14 | 一致時にEXITでループ終了 | E-02 (881行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで明確に確認済み
- **0（低リスク）**: 画面連携は画面機能マッピングで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] コロン区切り分割のregexp_substrパターンが正しいか
- [ ] UPPER比較による大文字・小文字無視の説明が正確か
- [ ] コードリーディングガイドの行番号が現在のソースと一致しているか
