---
generated_at: 2026-01-21 17:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-テスト結果型定義

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **文字列変換ロジック**：結果/エラーレベル/有効フラグの変換処理確認
  2. **使用ビューの詳細**：ファセット検索ビューの実装確認

## 2) 参照した情報（Evidence一覧）

- E-01: `src/plsql/typ/qa_test_results_row_t.sql` - オブジェクト型定義（1-27行目）
- E-02: `src/plsql/typ/qa_test_results_table_t.sql` - テーブル型定義（1-15行目）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能No.50の定義
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 関連画面情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 型名がqa_test_results_row_tである | E-01 (1行目) | ○ |
| C-02 | 型名がqa_test_results_table_tである | E-02 (1行目) | ○ |
| C-03 | qa_test_results_table_tはTABLE OF qa_test_results_row_tである | E-02 (13行目) | ○ |
| C-04 | qatr_id属性がNUMBER型 | E-01 (14行目) | ○ |
| C-05 | qatr_date属性がDATE型 | E-01 (15行目) | ○ |
| C-06 | qatr_scheme_name属性がVARCHAR2(100) | E-01 (16行目) | ○ |
| C-07 | qatr_category属性がVARCHAR2(100) | E-01 (17行目) | ○ |
| C-08 | qatr_result属性がVARCHAR2(20) | E-01 (18行目) | ○ |
| C-09 | qaru_name属性がVARCHAR2(100) | E-01 (19行目) | ○ |
| C-10 | qaru_layer属性がVARCHAR2(20) | E-01 (20行目) | ○ |
| C-11 | qaru_error_level属性がVARCHAR2(20) | E-01 (21行目) | ○ |
| C-12 | qaru_is_active属性がVARCHAR2(10) | E-01 (22行目) | ○ |
| C-13 | qaru_client_name属性がVARCHAR2(4000) | E-01 (23行目) | ○ |
| C-14 | qatr_program_name属性がVARCHAR2(500) | E-01 (24行目) | ○ |
| C-15 | 11属性で構成される | E-01 (14-24行目) | ○ |
| C-16 | 2023年12月にsprangにより追加 | E-01 (10行目), E-02 (10行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 文字列変換ロジック（結果/エラーレベル/有効フラグ）の具体的な実装箇所
  - 候補：ビュー定義内 / パッケージ内

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 型定義はソースコードから完全に確認済み
- 1: 中リスク - 文字列変換ロジックの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 文字列変換ロジック（結果: 0→'Failure', 1→'Success', 2→'Error'）を確認
- [ ] 文字列変換ロジック（エラーレベル: 1→'Error', 2→'Warning', 4→'Info'）を確認
- [ ] ファセット検索ビューの実装を確認
- [ ] パイプライン関数の存在を確認
