---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：51-QUASTOインストール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件「数分以内に完了」**：具体的な計測値の根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `install.sql` - インストールエントリーポイント（2行）
- E-02: `src/install_objects.sql` - メインインストールスクリプト（171行）
- E-03: `src/install_quasto_objects.sql` - QUASTOオブジェクトインストール（101行）
- E-04: `src/scripts/install_prereqs.sql` - 前提条件チェック（55行）
- E-05: `src/scripts/install_constant_package.sql` - 定数パッケージ生成（80行）
- E-06: `src/ddl/tab/qa_rules.sql` - QA_RULESテーブル定義（80行）
- E-07: `src/scripts/recompile_quasto_objects.sql` - 再コンパイルスクリプト（145行）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | install.sqlがinstall_objects.sqlを呼び出す | E-01 (2行目: @src/install_objects.sql) | ○ |
| C-02 | 4つの引数（utPLSQL, APEX, Jenkins, Logger）を受け付ける | E-02 (27-48行目のPROMPT文) | ○ |
| C-03 | 必要権限はCREATE SESSION, CREATE TABLE等9種類 | E-04 (14-22行目のl_req_privs定義) | ○ |
| C-04 | 権限不足時はエラー終了（ORA-20000） | E-04 (48行目のraise_application_error) | ○ |
| C-05 | qa_constant_pkgを動的に生成する | E-05 (25-63行目のEXECUTE IMMEDIATE) | ○ |
| C-06 | QA_RULESテーブルを作成する | E-03 (17行目), E-06 | ○ |
| C-07 | QA_IMPORT_FILESテーブルを作成する | E-03 (19行目) | ○ |
| C-08 | QARU_SEQ, QAIF_SEQシーケンスを作成する | E-03 (41-43行目) | ○ |
| C-09 | qa_rule_t等の型定義を作成する | E-03 (48-61行目) | ○ |
| C-10 | qa_api_pkg等のパッケージを作成する | E-03 (72-84行目) | ○ |
| C-11 | qa_api_pkgにpublic execute権限を付与 | E-03 (96行目: grant execute on qa_api_pkg to public) | ○ |
| C-12 | 既存オブジェクトがある場合はWARNING表示 | E-06 (71-72行目: dbms_output.put_line('WARNING...')) | ○ |
| C-13 | オブジェクトを再コンパイルする | E-07 (104-139行目のループ処理) | ○ |
| C-14 | インストール検証でuser_errorsを確認 | E-02 (150-157行目のSELECT文) | ○ |
| C-15 | install.logにログ出力 | E-02 (107行目: spool install.log) | ○ |
| C-16 | バージョン情報を埋め込む | E-05 (43行目: gc_quasto_version) | ○ |
| C-17 | 画面No.13（Login Page）と関連 | E-09 (32行目) | ○ |
| C-18 | インストール処理は数分以内に完了 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件「数分以内に完了」の具体的な計測値
  - 候補：ベンチマークテスト結果 / 運用実績データ / 開発者へのヒアリング

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理フロー、データベース操作仕様は実コードから正確に抽出
- 0: 低リスク - 権限チェックロジックは実コードで確認済み
- 1: 中リスク - パフォーマンス要件は推定値のため、実環境での確認を推奨

## 6) レビュアーチェックリスト（最小）
- [ ] install_objects.sqlの引数解析ロジックが正しく記載されているか
- [ ] 必要権限リストが最新か（install_prereqs.sqlと一致するか）
- [ ] 作成されるオブジェクト一覧に漏れがないか
- [ ] grant文の権限付与先が適切か（publicへの公開是非）
- [ ] パフォーマンス要件「数分以内」が実環境で妥当か確認
