---
generated_at: 2026-01-21 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：52-utPLSQLオブジェクトインストール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/install_utplsql_objects.sql` - utPLSQLオブジェクトインストールスクリプト（68行）
- E-02: `src/ddl/tab/qa_test_results.sql` - QA_TEST_RESULTSテーブル定義（49行）
- E-03: `src/scripts/create_scheduler_job_for_unit_tests.sql` - スケジューラジョブ作成（46行）
- E-04: `src/install_objects.sql` - メインインストールスクリプト（171行）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | QA_TEST_RESULTSテーブルを作成する | E-01 (9行目: @src/ddl/tab/qa_test_results.sql) | ○ |
| C-02 | QA_TEST_RUNSテーブルを作成する | E-01 (10-11行目) | ○ |
| C-03 | QA_TEST_RUN_INVALID_OBJECTSテーブルを作成する | E-01 (12-13行目) | ○ |
| C-04 | QATR_SEQ, QATO_SEQ, QATRU_SEQシーケンスを作成 | E-01 (38-43行目) | ○ |
| C-05 | qa_unit_tests_pkgパッケージを作成する | E-01 (58行目) | ○ |
| C-06 | CRONJOB_RUN_UNIT_TESTSスケジューラジョブを作成 | E-01 (64行目), E-03 | ○ |
| C-07 | ジョブは初期状態で無効（enabled=false） | E-03 (22行目: enabled => false) | ○ |
| C-08 | ジョブはFREQ=DAILYで日次実行 | E-03 (19行目: repeat_interval => 'FREQ=DAILY') | ○ |
| C-09 | ジョブはqa_unit_tests_pkg.p_run_all_unit_testsを実行 | E-03 (15行目: job_action) | ○ |
| C-10 | 既存ジョブがある場合はWARNING表示 | E-03 (37-38行目: dbms_output.put_line('WARNING...')) | ○ |
| C-11 | QA_TEST_RESULTSはCLOB型でXMLを保存 | E-02 (7行目: qatr_xml_result CLOB not null) | ○ |
| C-12 | install_objects.sqlから引数1=1で呼び出される | E-04 (69-73行目, 127行目) | ○ |
| C-13 | Dashboard画面（No.2）と関連 | E-06 (4行目: QA_TEST_RUNSテーブル) | ○ |
| C-14 | Unit Test Generation画面（No.3）と関連 | E-06 (6-7行目) | ○ |
| C-15 | Test Result Files画面（No.6）と関連 | E-06 (10-13行目) | ○ |
| C-16 | Config Scheduler Job画面（No.10）と関連 | E-06 (25-26行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル定義、シーケンス定義は実DDLから正確に抽出
- 0: 低リスク - スケジューラジョブのパラメータは実コードで確認済み
- 0: 低リスク - 画面との関連は画面機能マッピング.csvから正確に抽出

## 6) レビュアーチェックリスト（最小）
- [ ] install_utplsql_objects.sqlのスクリプト呼び出し順序が正しいか
- [ ] QA_TEST_RESULTS, QA_TEST_RUNS, QA_TEST_RUN_INVALID_OBJECTSのカラム定義が最新か
- [ ] スケジューラジョブCRONJOB_RUN_UNIT_TESTSの設定値が妥当か
- [ ] 画面との関連が漏れなく記載されているか
