---
generated_at: 2026-01-21 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-APEXオブジェクトインストール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/install_apex_objects.sql` - APEXオブジェクトインストールスクリプト（76行）
- E-02: `src/install_objects.sql` - メインインストールスクリプト（171行）
- E-03: `src/apex/f141/install.sql` - APEXアプリケーションインストール（135行）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | qa_test_results_row_t型を作成する | E-01 (9行目) | ○ |
| C-02 | qa_test_results_table_t型を作成する | E-01 (11行目) | ○ |
| C-03 | qa_apex_blacklisted_apps_vビューを作成する | E-01 (17行目) | ○ |
| C-04 | qa_application_owner_vビューを作成する | E-01 (19行目) | ○ |
| C-05 | qa_overview_tests_p0001_vビューを作成する | E-01 (22行目) | ○ |
| C-06 | qa_overview_quota_p0001_vビューを作成する | E-01 (24行目) | ○ |
| C-07 | qa_faceted_search_dashboard_data_p0001_vビューを作成する | E-01 (31-32行目) | ○ |
| C-08 | qa_unit_test_packages_p0002_vビューを作成する | E-01 (34行目) | ○ |
| C-09 | qa_test_runtime_error_p0003_vビューを作成する | E-01 (36行目) | ○ |
| C-10 | qa_rules_p0006_vビューを作成する | E-01 (41-42行目) | ○ |
| C-11 | qa_rule_categories_lov等のLOVビューを作成する | E-01 (54-63行目) | ○ |
| C-12 | qa_apex_app_pkgパッケージを作成する | E-01 (68-69行目) | ○ |
| C-13 | qa_apex_api_pkgパッケージを作成する | E-01 (70-71行目) | ○ |
| C-14 | install_objects.sqlから引数2=1で呼び出される | E-02 (75-78行目, 128行目) | ○ |
| C-15 | ビュー名にAPEXページ番号（p00xx）を含める命名規則 | E-01 (22-52行目の各ビュー名) | ○ |
| C-16 | Dashboard画面（No.2）と関連 | E-05 (2-5行目) | ○ |
| C-17 | Rules画面（No.7）と関連 | E-05 (14-16行目) | ○ |
| C-18 | APEXアプリケーション本体は別途インストール | E-03 (存在確認) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ビュー・パッケージ作成順序は実スクリプトから正確に抽出
- 0: 低リスク - ビュー命名規則（p00xx）は実コードで確認済み
- 0: 低リスク - 画面との関連は画面機能マッピング.csvから正確に抽出

## 6) レビュアーチェックリスト（最小）
- [ ] install_apex_objects.sqlのスクリプト呼び出し順序が正しいか
- [ ] 型定義（qa_test_results_row_t, qa_test_results_table_t）の構造が正しいか
- [ ] ビュー命名規則（p00xx）とAPEXページ番号の対応が正しいか
- [ ] qa_apex_app_pkg, qa_apex_api_pkgの役割分担が明確に記載されているか
- [ ] 画面との関連が漏れなく記載されているか
