---
generated_at: 2026-01-21 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-アンインストール

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `uninstall.sql` - アンインストールエントリーポイント（3行）
- E-02: `src/uninstall_all_objects.sql` - メインアンインストールスクリプト（357行）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | uninstall.sqlがuninstall_all_objects.sqlを呼び出す | E-01 (2行目: @src/uninstall_all_objects.sql) | ○ |
| C-02 | QA_TEST_RUN_INVALID_OBJECTSテーブルを削除する | E-02 (31-33行目) | ○ |
| C-03 | QA_TEST_RUNSテーブルを削除する | E-02 (34-36行目) | ○ |
| C-04 | QA_TEST_RESULTSテーブルを削除する | E-02 (37-39行目) | ○ |
| C-05 | QA_RULESテーブルを削除する | E-02 (40-42行目) | ○ |
| C-06 | QA_IMPORT_FILESテーブルを削除する | E-02 (43-45行目) | ○ |
| C-07 | 外部キー制約を先に削除する | E-02 (209-243行目のループ処理) | ○ |
| C-08 | QA_*パッケージを削除する（11個） | E-02 (49-78行目) | ○ |
| C-09 | 型定義をFORCEオプションで削除する | E-02 (247-251行目: l_action := l_action || ' force') | ○ |
| C-10 | VARCHAR2_TAB_T型を削除する | E-02 (83-85行目) | ○ |
| C-11 | シーケンス5個を削除する | E-02 (112-126行目: QARU_SEQ, QAIF_SEQ, QATR_SEQ, QATO_SEQ, QATRU_SEQ) | ○ |
| C-12 | ビュー24個以上を削除する | E-02 (129-204行目) | ○ |
| C-13 | CRONJOB_RUN_UNIT_TESTSジョブを削除する | E-02 (294-302行目: dbms_scheduler.drop_job) | ○ |
| C-14 | ジョブ削除時にforce => trueを使用する | E-02 (301行目: force => true) | ○ |
| C-15 | QA_UT_*パターンのパッケージを動的削除する | E-02 (312-319行目: object_name like 'QA\_UT\_%') | ○ |
| C-16 | PURGE RECYCLEBINを実行する | E-02 (324行目: purge recyclebin) | ○ |
| C-17 | user_objectsで残存オブジェクトを確認する | E-02 (338-343行目: select from user_objects) | ○ |
| C-18 | 残存オブジェクトがある場合はエラーメッセージを表示 | E-02 (346-347行目: dbms_output.put_line('ERROR...')) | ○ |
| C-19 | 成功時は完了メッセージを表示 | E-02 (349行目: 'Uninstallation completed successfully.') | ○ |
| C-20 | ログはuninstall.logに出力される | E-02 (9行目: spool uninstall.log) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。すべての主張に対して根拠が確認できた。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 削除対象オブジェクトリストは実コードから正確に抽出
- 0: 低リスク - 外部キー制約削除ロジックは実コードで確認済み
- 0: 低リスク - FORCEオプション使用箇所は実コードで確認済み
- 1: 中リスク - APEXアプリケーション（f141）が削除対象外であることの明記を確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 削除対象オブジェクトリストに漏れがないか
- [ ] 外部キー制約削除ロジックが正しく記載されているか
- [ ] FORCEオプションの使用箇所が正しいか（型定義のみ）
- [ ] スケジューラジョブ削除のforce => true指定が正しいか
- [ ] QA_UT_*パターンによる動的削除の記載が正しいか
- [ ] PURGE RECYCLEBINの実行が記載されているか
- [ ] アンインストール検証ロジックが正しく記載されているか
