---
generated_at: 2026-01-21 16:55:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-先行ルール依存関係

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/ddl/tab/qa_rules.sql` - QA_RULESテーブル定義
- E-02: `src/plsql/pkg/qa_main_pkg.sql` - ルール管理パッケージ
- E-03: `src/plsql/pkg/qa_api_pkg.sql` - ルール実行API
- E-04: `src/plsql/vw/qa_predecessor_order_v.sql` - 先行ルール順序ビュー
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | qaru_predecessor_ids列にコロン区切りで先行ルール番号を指定 | E-01 (53行目コメント), E-05 | ○ |
| C-02 | VARCHAR2(4000 CHAR)型 | E-01 (18行目) | ○ |
| C-03 | f_check_for_loop関数でループ検出 | E-02 (181-185行目, 899-960行目) | ○ |
| C-04 | ORA-1436でループ検出 | E-02 (909-911行目: pragma exception_init) | ○ |
| C-05 | f_get_full_rule_pred関数で全先行ルール取得 | E-02 (192行目, 962-1004行目) | ○ |
| C-06 | qa_predecessor_order_vビューで実行順序算出 | E-04 (1-30行目) | ○ |
| C-07 | 階層クエリ（CONNECT BY NOCYCLE）使用 | E-04 (25行目), E-02 (939行目) | ○ |
| C-08 | splitted_pred CTEでコロン区切り分割 | E-04 (10-20行目) | ○ |
| C-09 | max_step = stepで最終階層のみ取得 | E-04 (28行目) | ○ |
| C-10 | tf_run_rulesでf_check_for_loop呼び出し | E-03 (186-191行目) | ○ |
| C-11 | tf_get_rule_numbersでqa_predecessor_order_vと結合 | E-02 (509-515行目) | ○ |
| C-12 | ORA-1436例外時にログ記録して再スロー | E-02 (946-952行目) | ○ |
| C-13 | f_get_full_rule_predで再帰呼び出し | E-02 (987行目) | ○ |
| C-14 | qa_running_rule_tでpredecessor属性追跡 | E-03 (193-212行目) | ○ |
| C-15 | 先行ルールすべて成功で後続実行 | E-03 (228行目: l_allowed_to_run = 0) | ○ |
| C-16 | regexp_substrでコロン区切り分割 | E-04 (13-14行目), E-02 (926-929行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで明確に確認済み
- **0（低リスク）**: 階層クエリのロジックはビュー定義で確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ORA-1436とpragma exception_initの説明が正確か
- [ ] qa_predecessor_order_vの階層クエリロジックが正確に記載されているか
- [ ] コードリーディングガイドの行番号が現在のソースと一致しているか
