---
generated_at: 2026-01-21 17:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-ルール属性取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_main_pkg.sql` - ルール管理パッケージ
- E-02: `src/plsql/typ/qa_rule_t.sql` - ルール型定義
- E-03: `src/plsql/pkg/qa_api_pkg.sql` - ルール実行API
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | f_get_rule関数でqa_rule_t型を返却 | E-01 (21-25行目, 213-256行目) | ○ |
| C-02 | f_get_rule_pk関数でqaru_idを返却 | E-01 (27-38行目, 258-288行目) | ○ |
| C-03 | f_get_rule_category関数でカテゴリを返却 | E-01 (52-62行目, 328-359行目) | ○ |
| C-04 | f_get_rule_name関数でルール名を返却 | E-01 (64-74行目, 361-392行目) | ○ |
| C-05 | f_get_rule_layer関数でレイヤーを返却 | E-01 (76-86行目, 394-425行目) | ○ |
| C-06 | f_get_rule_error_level関数でエラーレベルを返却 | E-01 (88-98行目, 427-458行目) | ○ |
| C-07 | gc_apex_flag変数でAPEX除外制御 | E-01 (206-211行目) | ○ |
| C-08 | qa_constant_pkg.gc_apex_flag=0でAPEX除外 | E-01 (207行目) | ○ |
| C-09 | qa_rule_tコンストラクタで6属性を設定 | E-02 (41-49行目) | ○ |
| C-10 | authid definerでパッケージ定義 | E-01 (1行目) | ○ |
| C-11 | NO_DATA_FOUND時はログ記録して再スロー | E-01 (244-249行目) | ○ |
| C-12 | qa_logger_pkg.append_paramでパラメータログ | E-01 (224-228行目) | ○ |
| C-13 | tf_run_ruleでf_get_rule呼び出し | E-03 (93-94行目) | ○ |
| C-14 | SELECT文でAPEX除外条件を適用 | E-01 (240行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで明確に確認済み
- **0（低リスク）**: 関数仕様と実装の対応が確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 6つの関数（f_get_rule, f_get_rule_pk, f_get_rule_category, f_get_rule_name, f_get_rule_layer, f_get_rule_error_level）が正しく記載されているか
- [ ] gc_apex_flagのロジックが正確か
- [ ] コードリーディングガイドの行番号が現在のソースと一致しているか
