---
generated_at: 2026-01-21 17:05:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-ルール存在確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_main_pkg.sql` - ルール管理パッケージ
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | f_exist_rules関数として実装 | E-01 (100-105行目, 460-491行目) | ○ |
| C-02 | pi_qaru_client_nameパラメータ（デフォルトNULL） | E-01 (105行目) | ○ |
| C-03 | 戻り値はBOOLEAN型 | E-01 (105行目) | ○ |
| C-04 | EXISTS句を使用して存在確認 | E-01 (473-476行目) | ○ |
| C-05 | DECODE(COUNT(1), 0, 0, 1)で結果変換 | E-01 (470行目) | ○ |
| C-06 | l_result=0でFALSE返却 | E-01 (478-480行目) | ○ |
| C-07 | l_result!=0でTRUE返却 | E-01 (481-483行目) | ○ |
| C-08 | NULLパラメータで全ルール対象 | E-01 (476行目: OR pi_qaru_client_name IS NULL) | ○ |
| C-09 | qa_logger_pkg.append_paramでパラメータログ | E-01 (466-468行目) | ○ |
| C-10 | OTHERS例外時はログ記録して再スロー | E-01 (485-490行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: すべての主張がソースコードで明確に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] EXISTS句のロジックが正確に記載されているか
- [ ] DECODE関数の説明が正確か
- [ ] コードリーディングガイドの行番号が現在のソースと一致しているか
