---
generated_at: 2026-01-21 16:15:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/apex/f141/application/pages/page_00000.sql`
- E-02: `src/apex/f141/application/pages/page_00001.sql`
- E-03: `src/apex/f141/application/pages/page_00002.sql`
- E-04: `src/apex/f141/application/pages/page_00003.sql`
- E-05: `src/apex/f141/application/pages/page_00004.sql`
- E-06: `src/apex/f141/application/pages/page_00005.sql`
- E-07: `src/apex/f141/application/pages/page_00006.sql`
- E-08: `src/apex/f141/application/pages/page_00007.sql`
- E-09: `src/apex/f141/application/pages/page_00008.sql`
- E-10: `src/apex/f141/application/pages/page_00009.sql`
- E-11: `src/apex/f141/application/pages/page_00011.sql`
- E-12: `src/apex/f141/application/pages/page_00020.sql`
- E-13: `src/apex/f141/application/pages/page_09999.sql`
- E-14: `src/apex/f141/application/pages/page_groups.sql`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Global Page (Page 0) はフッターにプロバイダースローガンを表示 | E-01 (p_plug_name=>'Provider Slogan', REGION_POSITION_05) | ○ |
| C-02 | Dashboard (Page 1) はテスト実行結果表示、Quota円グラフ、タイムラインチャート、ファセット検索を含む | E-02 (p_name=>'Dashboard', plug_name=>'Quota Chart', 'Timeline Chart', 'Filter') | ○ |
| C-03 | Unit Test Generation (Page 2) はモーダルダイアログでUnit Test生成・削除機能を提供 | E-03 (p_page_mode=>'MODAL', button GENERATE, DELETE) | ○ |
| C-04 | Runtime Error (Page 3) はランタイムエラーバックトレース表示モーダル | E-04 (p_page_mode=>'MODAL', p_prompt=>'Error Backtrace') | ○ |
| C-05 | Invalid Objects (Page 4) は無効オブジェクトレポートをInteractive Reportで表示 | E-05 (p_page_mode=>'MODAL', plug_source_type=>'NATIVE_IR') | ○ |
| C-06 | Test Result Files (Page 5) はXMLファイルのアップロード・ダウンロード機能を提供 | E-06 (P5_XML_FILE, attribute_11=>'.xml', button UPLOAD) | ○ |
| C-07 | Rules (Page 6) はルール一覧をInteractive Reportで表示、Create Rule/Unit Test Generation/Rule Filesボタンを含む | E-07 (plug_source_type=>'NATIVE_IR', button CREATE_RULE, UNIT_TEST_GENERATION, RULE_FILES) | ○ |
| C-08 | Add/Edit Rule (Page 7) はルール編集フォームモーダル、保存・削除・作成機能を提供 | E-08 (p_page_mode=>'MODAL', button SAVE, DELETE, CREATE) | ○ |
| C-09 | Rule Files (Page 8) はJSONファイルのインポート・エクスポート機能を提供 | E-09 (P8_JSON_FILE, attribute_11=>'.json', button IMPORT) | ○ |
| C-10 | Config Scheduler Job (Page 9) はスケジューラー設定モーダル、ジョブ有効/無効・手動実行・履歴確認機能を提供 | E-10 (P9_ENABLE_SCHEDULER_JOB, button RUN_CRONJOB_NOW, 'Job History') | ○ |
| C-11 | Restart Unit Test (Page 11) は個別Unit Test再実行モーダル | E-11 (p_page_mode=>'MODAL', button RESTART_UNIT_TEST) | ○ |
| C-12 | Region Plugin (Page 20) はQUASTOリージョンプラグインデモ画面 | E-12 (plug_source_type=>'PLUGIN_QUASTO_REGION') | ○ |
| C-13 | Login Page (Page 9999) はユーザー認証画面、Remember me機能を提供 | E-13 (p_page_is_public_y_n=>'Y', P9999_USERNAME, P9999_PASSWORD, P9999_REMEMBER) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての画面情報はOracle APEX SQLエクスポートファイルから直接抽出

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接検証可能

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧の画面名がソースコードの `p_name` パラメータと一致しているか確認
- [ ] 画面遷移図のボタン遷移先が `p_button_redirect_url` と一致しているか確認
- [ ] モーダルダイアログの判定（`p_page_mode=>'MODAL'`）が正確か確認
- [ ] ページエイリアス（`p_alias`）が正確に記載されているか確認
