# 画面遷移図

本ドキュメントは、QUASTO（Oracle APEXアプリケーション）の画面遷移を示します。

## 全体遷移図

```mermaid
flowchart TD
    subgraph Authentication["認証"]
        LOGIN[("Login Page<br/>Page 9999")]
    end

    subgraph Main["メイン画面"]
        DASHBOARD[("Dashboard<br/>Page 1")]
        RULES[("Rules<br/>Page 6")]
        REGION_PLUGIN[("Region Plugin<br/>Page 20")]
    end

    subgraph Dashboard_Modals["Dashboard関連モーダル"]
        CONFIG_SCHEDULER[("Config Scheduler Job<br/>Page 9")]
        TEST_RESULT_FILES[("Test Result Files<br/>Page 5")]
        INVALID_OBJECTS[("Invalid Objects<br/>Page 4")]
        RUNTIME_ERROR[("Runtime Error<br/>Page 3")]
        RESTART_UNIT_TEST[("Restart Unit Test<br/>Page 11")]
    end

    subgraph Rules_Modals["Rules関連モーダル"]
        ADD_EDIT_RULE[("Add/Edit Rule<br/>Page 7")]
        UNIT_TEST_GEN[("Unit Test Generation<br/>Page 2")]
        RULE_FILES[("Rule Files<br/>Page 8")]
    end

    %% 認証フロー
    LOGIN -->|ログイン成功| DASHBOARD

    %% ナビゲーション（メイン画面間）
    DASHBOARD <-->|メニュー| RULES
    DASHBOARD <-->|メニュー| REGION_PLUGIN
    RULES <-->|メニュー| REGION_PLUGIN

    %% Dashboard画面からの遷移
    DASHBOARD -->|"Config Scheduler Job<br/>ボタン"| CONFIG_SCHEDULER
    DASHBOARD -->|"Test Result Files<br/>ボタン"| TEST_RESULT_FILES
    DASHBOARD -->|"Details<br/>リンク"| INVALID_OBJECTS
    DASHBOARD -->|"Runtime Error<br/>アイコン"| RUNTIME_ERROR
    DASHBOARD -->|"Restart<br/>リンク"| RESTART_UNIT_TEST

    %% Rules画面からの遷移
    RULES -->|"Create Rule<br/>ボタン"| ADD_EDIT_RULE
    RULES -->|"編集アイコン"| ADD_EDIT_RULE
    RULES -->|"Unit Test Generation<br/>ボタン"| UNIT_TEST_GEN
    RULES -->|"Rule Files<br/>ボタン"| RULE_FILES

    %% モーダルダイアログの戻り
    CONFIG_SCHEDULER -->|閉じる| DASHBOARD
    TEST_RESULT_FILES -->|閉じる| DASHBOARD
    INVALID_OBJECTS -->|閉じる| DASHBOARD
    RUNTIME_ERROR -->|閉じる| DASHBOARD
    RESTART_UNIT_TEST -->|閉じる| DASHBOARD
    ADD_EDIT_RULE -->|閉じる/保存| RULES
    UNIT_TEST_GEN -->|閉じる| RULES
    RULE_FILES -->|閉じる| RULES
```

## 画面遷移の説明

### 1. 認証フロー

| 遷移元 | 遷移先 | トリガー | 説明 |
|--------|--------|----------|------|
| Login Page | Dashboard | Sign Inボタン | ユーザー認証成功後、ダッシュボードへ遷移 |

### 2. メイン画面間の遷移

| 遷移元 | 遷移先 | トリガー | 説明 |
|--------|--------|----------|------|
| Dashboard | Rules | ナビゲーションメニュー | ルール管理画面へ遷移 |
| Dashboard | Region Plugin | ナビゲーションメニュー | プラグインデモ画面へ遷移 |
| Rules | Dashboard | ナビゲーションメニュー | ダッシュボードへ戻る |

### 3. Dashboard画面からのモーダル遷移

| 遷移元 | 遷移先 | トリガー | 説明 |
|--------|--------|----------|------|
| Dashboard | Config Scheduler Job | Config Scheduler Jobボタン | スケジューラー設定ダイアログを開く |
| Dashboard | Test Result Files | Test Result Filesボタン | テスト結果ファイル管理ダイアログを開く |
| Dashboard | Invalid Objects | Detailsリンク | テスト結果の詳細（無効オブジェクト）を表示 |
| Dashboard | Runtime Error | Runtime Errorアイコン | ランタイムエラーの詳細を表示 |
| Dashboard | Restart Unit Test | Restartリンク | Unit Test再実行ダイアログを開く |

### 4. Rules画面からのモーダル遷移

| 遷移元 | 遷移先 | トリガー | 説明 |
|--------|--------|----------|------|
| Rules | Add/Edit Rule | Create Ruleボタン | 新規ルール作成ダイアログを開く |
| Rules | Add/Edit Rule | 編集アイコン（レポート行） | 既存ルール編集ダイアログを開く |
| Rules | Unit Test Generation | Unit Test Generationボタン | Unit Test生成ダイアログを開く |
| Rules | Rule Files | Rule Filesボタン | ルールファイル管理ダイアログを開く |

### 5. モーダルダイアログからの戻り

全てのモーダルダイアログは「Close」ボタンまたは処理完了後に親画面へ戻ります。
親画面は、ダイアログが閉じた際に関連するレポート/チャートを自動的にリフレッシュします。

## ページ一覧

| Page ID | ページ名 | タイプ | 説明 |
|---------|----------|--------|------|
| 0 | Global Page | システム | 全ページ共通設定 |
| 1 | Dashboard | 通常ページ | テスト結果ダッシュボード |
| 2 | Unit Test Generation | モーダル | Unit Test生成/削除 |
| 3 | Runtime Error | モーダル | エラー詳細表示 |
| 4 | Invalid Objects | モーダル | 無効オブジェクト詳細 |
| 5 | Test Result Files | モーダル | XMLファイル管理 |
| 6 | Rules | 通常ページ | ルール一覧/管理 |
| 7 | Add/Edit Rule | モーダル | ルール編集フォーム |
| 8 | Rule Files | モーダル | JSONファイル管理 |
| 9 | Config Scheduler Job | モーダル | スケジューラー設定 |
| 11 | Restart Unit Test | モーダル | Unit Test再実行 |
| 20 | Region Plugin | 通常ページ | プラグインデモ |
| 9999 | Login Page | 認証ページ | ログイン |
