---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **Login Page - QUASTOインストール**：機能との直接的な関連性が薄い
  2. **Global Page**：画面一覧に存在するが、機能との直接的なマッピングが不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `src/apex/f141/application/pages/page_00001.sql` (Dashboard)
- E-04: `src/apex/f141/application/pages/page_00002.sql` (Unit Test Generation)
- E-05: `src/apex/f141/application/pages/page_00003.sql` (Runtime Error)
- E-06: `src/apex/f141/application/pages/page_00004.sql` (Invalid Objects)
- E-07: `src/apex/f141/application/pages/page_00005.sql` (Test Result Files)
- E-08: `src/apex/f141/application/pages/page_00006.sql` (Rules)
- E-09: `src/apex/f141/application/pages/page_00007.sql` (Add/Edit Rule)
- E-10: `src/apex/f141/application/pages/page_00008.sql` (Rule Files)
- E-11: `src/apex/f141/application/pages/page_00009.sql` (Config Scheduler Job)
- E-12: `src/apex/f141/application/pages/page_00011.sql` (Restart Unit Test)
- E-13: `src/apex/f141/application/pages/page_00020.sql` (Region Plugin)
- E-14: `src/apex/f141/application/pages/page_09999.sql` (Login Page)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Dashboard - ダッシュボードデータ取得（主機能） | E-03: `qa_apex_app_pkg.get_faceted_search_dashboard_data`呼び出し、E-02: 機能No.26 | ○ |
| C-02 | Dashboard - ファセット検索コレクション生成（補助機能） | E-03: `qa_apex_app_pkg.p_fill_faceted_search_collection`呼び出し、E-02: 機能No.31 | ○ |
| C-03 | Dashboard - テスト実行履歴格納（主機能） | E-03: `QA_OVERVIEW_TESTS_P0001_V`ビュー参照、E-02: 機能No.45 | ○ |
| C-04 | Dashboard - テスト結果XML格納（API連携） | E-03: テスト詳細リンク、E-02: 機能No.44 | ○ |
| C-05 | Unit Test Generation - ユニットテストパッケージ生成（主機能） | E-04: `QA_UNIT_TESTS_PKG.p_create_unit_tests_for_schemes`呼び出し、E-02: 機能No.14 | ○ |
| C-06 | Unit Test Generation - ユニットテストパッケージ削除（主機能） | E-04: `QA_UNIT_TESTS_PKG.p_delete_unit_tests_for_schemes`呼び出し、E-02: 機能No.15 | ○ |
| C-07 | Runtime Error - テスト例外処理（主機能） | E-05: `QA_TEST_RUNTIME_ERROR_P0003_V`ビュー参照、E-02: 機能No.21 | ○ |
| C-08 | Invalid Objects - 無効オブジェクト格納（主機能） | E-06: `QA_TEST_RUN_DETAILS_P0004_V`ビュー参照、E-02: 機能No.46 | ○ |
| C-09 | Test Result Files - テスト結果インポート（主機能） | E-07: `qa_apex_app_pkg.p_upload_unit_test_xml`呼び出し、E-02: 機能No.22 | ○ |
| C-10 | Test Result Files - テスト結果エクスポート（主機能） | E-07: ダウンロードリンク、E-02: 機能No.23 | ○ |
| C-11 | Test Result Files - テスト結果XMLアップロード（補助機能） | E-07: `p_upload_unit_test_xml`プロセス、E-02: 機能No.29 | ○ |
| C-12 | Test Result Files - テスト結果XMLダウンロード（補助機能） | E-07: `getUTXMLAttachment`プロセス、E-02: 機能No.30 | ○ |
| C-13 | Rules - ルール定義（主機能） | E-08: `QA_RULES_P0006_V`ビュー参照、E-02: 機能No.1 | ○ |
| C-14 | Rules - ルール有効/無効制御（API連携） | E-08: `QARU_IS_ACTIVE`列表示、E-02: 機能No.4 | ○ |
| C-15 | Rules - ルール挿入（遷移先機能） | E-08: CREATE_RULEボタンでPage 7へ遷移、E-02: 機能No.9 | ○ |
| C-16 | Add/Edit Rule - ルール定義（主機能） | E-09: `QA_RULES_P0007_V`ビューでフォーム表示、E-02: 機能No.1 | ○ |
| C-17 | Add/Edit Rule - ルール挿入（主機能） | E-09: `NATIVE_FORM_DML`プロセス（INSERT）、E-02: 機能No.9 | ○ |
| C-18 | Add/Edit Rule - ルール有効/無効制御（補助機能） | E-09: `P7_QARU_IS_ACTIVE`項目（Yes/No）、E-02: 機能No.4 | ○ |
| C-19 | Add/Edit Rule - オブジェクト除外（補助機能） | E-09: `P7_QARU_EXCLUDE_OBJECTS`項目、E-02: 機能No.5 | ○ |
| C-20 | Rule Files - ルールJSONエクスポート（主機能） | E-10: `getRuleJSONAttachment`プロセス、E-02: 機能No.10 | ○ |
| C-21 | Rule Files - ルールJSONインポート（主機能） | E-10: `qa_apex_app_pkg.p_upload_rules_json`呼び出し、E-02: 機能No.11 | ○ |
| C-22 | Rule Files - ルールJSONアップロード（補助機能） | E-10: `p_upload_rules_json`プロセス、E-02: 機能No.27 | ○ |
| C-23 | Rule Files - ルールJSONダウンロード（補助機能） | E-10: ダウンロードリンク、E-02: 機能No.28 | ○ |
| C-24 | Config Scheduler Job - スケジューラジョブ制御（主機能） | E-11: `qa_unit_tests_pkg.p_enable_scheduler_cronjob`呼び出し、E-02: 機能No.19 | ○ |
| C-25 | Config Scheduler Job - 全ユニットテスト実行（API連携） | E-11: `qa_unit_tests_pkg.p_trigger_scheduler_cronjob`呼び出し、E-02: 機能No.16 | ○ |
| C-26 | Restart Unit Test - 単一ユニットテスト実行（主機能） | E-12: `qa_unit_tests_pkg.p_create_custom_unit_test_job`呼び出し、E-02: 機能No.17 | ○ |
| C-27 | Restart Unit Test - カスタムテストジョブ作成（主機能） | E-12: `p_create_custom_unit_test_job`プロセス、E-02: 機能No.18 | ○ |
| C-28 | Region Plugin - 単一ルール実行（主機能） | E-13: `PLUGIN_QUASTO_REGION`、E-02: 機能No.2 | ○ |
| C-29 | Region Plugin - APEXルール実行（主機能） | E-13: APEX用ルール選択、E-02: 機能No.24 | ○ |
| C-30 | Login Page - QUASTOインストール（遷移先機能） | E-14 | △ |

## 4) 不足情報（Unknown / Missing）
- **Global Page（画面No.1）**：グローバルページは全ページで共通して使用されるため、特定の機能との直接的なマッピングが存在しない
  - 候補：フッター表示機能 / セッション管理機能 / 共通レイアウト機能
- **Login Page - QUASTOインストール**：ログイン機能自体はAPEX標準認証を使用しており、QUASTOインストール機能との直接的な関連性が薄い
  - 候補：ユーザー認証機能 / セッション開始機能

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全体的にソースコードとの整合性が高い
- **1（中リスク）**: Login Pageの機能マッピングは要確認。APEX標準認証を使用しているため、QUASTOカスタム機能との関連は限定的

## 6) レビュアーチェックリスト（最小）
- [ ] 画面No.1（Global Page）の扱いを確認（機能マッピングから除外するか、共通機能として別途定義するか）
- [ ] 各画面の「関連種別」が適切かどうかを確認（主機能/補助機能/遷移先機能/API連携の分類）
- [ ] Dashboard画面の機能マッピングが網羅的かどうかを確認（チャート描画、フィルタリング等）
- [ ] Rules画面とAdd/Edit Rule画面の機能の重複・関連性が適切かどうかを確認
- [ ] Region Plugin画面のプラグイン動作と機能マッピングの整合性を確認
