# 画面設計書 2-Dashboard

## 概要

本ドキュメントは、QUASTO（Oracle APEXアプリケーション）のDashboard画面（Page ID: 1）の設計書である。Dashboard画面はテスト実行結果を視覚的に表示するメインダッシュボード画面であり、ユニットテストの実行状況を一元的に把握できる。

### 本画面の処理概要

Dashboard画面は、QUASTOアプリケーションのメイン画面として、テスト実行結果を複数の視点から可視化する。Quota円グラフでテスト結果の内訳（Success/Failure/Error）を表示し、タイムラインチャートで過去10日間のテスト実行推移を表示する。また、ファセット検索機能により、カテゴリ、クライアント/プロジェクト、スキーム、テスト結果、エラーレベル、実行日で結果をフィルタリングできる。

**業務上の目的・背景**：ソフトウェア品質管理において、テスト実行結果のトレンドを把握することは、品質劣化の早期発見やリグレッション検出に不可欠である。Dashboard画面は、開発チームや品質管理者がテスト状況を俯瞰的に把握し、問題のある領域を迅速に特定するための中心的なインターフェースとして機能する。複数のクライアント/プロジェクトのテスト結果を一元管理し、ファセット検索により必要な情報に素早くアクセスできる。

**画面へのアクセス方法**：ログイン成功後に自動的に遷移する。また、ナビゲーションメニューからいつでもアクセス可能。エイリアス「DASHBOARD」でのURLアクセスも可能。

**主要な操作・処理内容**：
1. ページロード時にファセット検索用コレクションを生成（Lazy Loading対応）
2. Quota円グラフでテスト結果のSuccess/Failure/Errorの割合を表示
3. Timeline Chartで過去10日間のテスト実行推移を折れ線グラフで表示
4. Test Executions Reportでテスト実行結果の詳細一覧を表示
5. ファセット検索でCategories、Clients/Projects、Schemes、Test Results、Error Levels、Datesによるフィルタリング
6. Config Scheduler Jobボタンでスケジューラー設定ダイアログを開く
7. Test Result Filesボタンでテスト結果ファイル管理ダイアログを開く
8. Detailsリンクで無効オブジェクト詳細を表示
9. Runtime Errorアイコンでランタイムエラー詳細を表示
10. Restartリンクで個別のUnit Testを再実行

**画面遷移**：
- 遷移元：Login Page（ログイン成功後）、Rules画面（メニュー）、Region Plugin画面（メニュー）
- 遷移先：Config Scheduler Job（モーダル）、Test Result Files（モーダル）、Invalid Objects（モーダル）、Runtime Error（モーダル）、Restart Unit Test（モーダル）、Rules（メニュー）、Region Plugin（メニュー）

**権限による表示制御**：Protection Level「C」（認証必須）が設定されており、ログイン済みユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 26 | ダッシュボードデータ取得 | 主機能 | テスト実行結果の一覧表示、Quota円グラフ、タイムラインチャートのデータを取得 |
| 31 | ファセット検索コレクション生成 | 補助機能 | ダッシュボードのファセット検索用コレクションを生成・更新 |
| 45 | テスト実行履歴格納 | 主機能 | QA_TEST_RUNSテーブルからテスト実行履歴データを表示 |
| 44 | テスト結果XML格納 | API連携 | テスト結果の詳細情報をQA_TEST_RESULTSから取得 |

## 画面種別

一覧 / ダッシュボード（チャート＋レポート複合画面）

## URL/ルーティング

- Page ID: 1
- エイリアス: DASHBOARD
- URL例: `f?p=141:1:SESSION_ID`または`f?p=141:DASHBOARD:SESSION_ID`

## 入出力項目

### ファセット検索項目（フィルター）

| 項目名 | 項目ID | タイプ | データソース | 説明 |
|--------|--------|--------|------------|------|
| Search | P1_SEARCH | 検索ボックス | ROW全体 | フリーテキスト検索 |
| Categories | P1_CATEGORIES | チェックボックス | QARU_CATEGORY | ルールカテゴリでフィルタ |
| Clients/Projects | P1_PROJECT | チェックボックス | QARU_CLIENT_NAME | クライアント/プロジェクトでフィルタ |
| Schemes | P1_SCHEME | チェックボックス | QATR_SCHEME_NAME | スキーム名でフィルタ |
| Test Results | P1_TEST_RESULT | チェックボックス | QATR_RESULT | テスト結果でフィルタ |
| Error Levels | P1_ERRORLEVEL | チェックボックス | QARU_ERROR_LEVEL | エラーレベルでフィルタ |
| Dates | P1_EXECUTION_DATE | チェックボックス | QATR_DATE | 実行日でフィルタ（OR結合、コロン区切り） |

### 隠し項目

| 項目名 | 項目ID | タイプ | 説明 |
|--------|--------|--------|------|
| Lazy Loading | P1_LAZY_LOADING | Hidden | レイジーローディング制御フラグ（1でロード完了） |

## 表示項目

### Quota円グラフ（QUOTA_CHART）

| 項目名 | 表示形式 | データソース | 説明 |
|--------|----------|-------------|------|
| Status Amount | 円グラフセグメント | QA_OVERVIEW_QUOTA_P0001_V.STATUS_AMOUNT | テスト状態ごとの件数 |
| Testcase Status | ラベル | QA_OVERVIEW_QUOTA_P0001_V.TESTCASE_STATUS | テスト状態名（Success/Failure/Error） |

### タイムラインチャート（TIMELINE_CHART）

| 項目名 | 表示形式 | データソース | 説明 |
|--------|----------|-------------|------|
| Success | 折れ線（エリア付） | QA_OVERVIEW_TIMELINE_SUCCESS_P0001_V | 成功テスト数の推移 |
| Failure | 折れ線（エリア付） | QA_OVERVIEW_TIMELINE_FAILURE_P0001_V | 失敗テスト数の推移 |
| Error | 折れ線（エリア付） | QA_OVERVIEW_TIMELINE_ERROR_P0001_V | エラーテスト数の推移 |

### Test Executions Report（TEST_REPORT）

| 項目名 | カラム別名 | 表示順序 | 説明 |
|--------|-----------|---------|------|
| Client Name | QARU_CLIENT_NAME | 10 | クライアント名（ブレイク列） |
| Date | QATR_DATE | 20 | 実行日（MM/DD/YYYY形式） |
| Scheme Name | QATR_SCHEME_NAME | 30 | スキーム名 |
| ID | QATR_ID | 50 | テスト結果ID |
| Test Result | QATR_RESULT | 60 | テスト結果（Success/Failure/Error） |
| Details | QATR_DETAILS | 70 | 詳細リンク（Invalid Objects画面へ） |
| Restart | QATR_RESTART_UNIT_TEST | 80 | 再実行リンク（Restart Unit Test画面へ） |
| Category | QARU_CATEGORY | 90 | ルールカテゴリ（LOV表示） |
| Rule Name | QARU_NAME | 100 | ルール名 |
| Layer | QARU_LAYER | 110 | レイヤー（LOV表示） |
| Error Level | QARU_ERROR_LEVEL | 120 | エラーレベル（LOV表示） |
| Active | QARU_IS_ACTIVE | 130 | アクティブ状態（Yes/No LOV表示） |
| Runtime Error | QATR_RUNTIME_ERROR | 140 | ランタイムエラーアイコン |
| Program Name | QATR_PROGRAM_NAME | 150 | プログラム名 |

## イベント仕様

### 1-Lazy loading refresh

**トリガー**: ページ読み込み完了時（ready）

**処理フロー**:
1. P1_LAZY_LOADINGを1に設定
2. RequireJS待機時間を10秒に設定
3. 待機スピナーを表示
4. `qa_apex_app_pkg.p_fill_faceted_search_collection`を実行してコレクション生成
5. Test Executions Reportをリフレッシュ
6. Filterリージョンをリフレッシュ
7. Timeline Chartをリフレッシュ
8. Quota Chartをリフレッシュ
9. 待機スピナーを削除

### 2-Filter Regions

**トリガー**: ファセット検索のフィルター変更時（facetschange）

**処理フロー**:
1. `qa_apex_app_pkg.p_fill_faceted_search_collection`でコレクション再生成
2. Test Executions Reportをリフレッシュ
3. Quota Chartをリフレッシュ
4. Timeline Chartをリフレッシュ

### 3-Refresh Reports after Dialog closed (Breadcrumb)

**トリガー**: Breadcrumb Barリージョンからのモーダルダイアログ終了時（apexafterclosecanceldialog）

**処理フロー**:
1. ファセット検索コレクションを再生成
2. Quota Chartをリフレッシュ
3. Timeline Chartをリフレッシュ
4. Test Executions Reportをリフレッシュ
5. Filterリージョンをリフレッシュ

### 4-Refresh Reports after Dialog closed (Test Execution Report)

**トリガー**: Test Execution Reportリージョンからのモーダルダイアログ終了時（apexafterclosecanceldialog）

**処理フロー**:
1. Quota Chartをリフレッシュ
2. Timeline Chartをリフレッシュ
3. Test Executions Reportをリフレッシュ
4. Filterリージョンをリフレッシュ

## データベース更新仕様

### 操作別データベース影響一覧

Dashboard画面は主に参照のみで、直接的なデータベース更新は行わない。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページロード | QA_OVERVIEW_TESTS_P0001_V | SELECT | テスト実行結果一覧を取得 |
| ページロード | QA_OVERVIEW_QUOTA_P0001_V | SELECT | Quota円グラフ用データを取得 |
| ページロード | QA_OVERVIEW_TIMELINE_*_P0001_V | SELECT | タイムラインチャート用データを取得 |
| ファセット検索 | APEX_COLLECTION | INSERT/UPDATE | ファセット検索用コレクションを生成・更新 |

### テーブル別更新項目詳細

#### APEX_COLLECTION (FACETED_SEARCH_DASHBOARD_DATA_P0001)

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | C001〜C011 | qa_apex_app_pkg.get_faceted_search_dashboard_dataの結果 | ファセット検索の高速化用コレクション |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 情報 | データなし | No test results found.（レポート/チャート） |

## 例外処理

| 例外状態 | 表示・動作 |
|---------|----------|
| データが見つからない | 「No test results found.」メッセージを表示 |
| コレクション生成エラー | qa_logger_pkgでエラーログを記録し、例外を再スロー |

## 備考

- 本画面はLazy Loading方式を採用しており、ページ表示後に非同期でデータを取得する
- ファセット検索のパフォーマンス向上のため、APEX Collectionを使用してデータをキャッシュ
- チャートのリンク機能により、グラフをクリックしてファセット検索フィルターを適用可能
- CSS変数を使用したカスタムスタイルにより、待機オーバーレイのz-indexを調整（z-index: 900）
- Universal ThemeのLeft Side Columnテンプレートを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ダッシュボードで使用されるビューとデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00001.sql | `src/apex/f141/application/pages/page_00001.sql` | ビュー名の確認（QA_OVERVIEW_*_P0001_V） |
| 1-2 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | get_faceted_search_dashboard_dataの構造理解 |

**読解のコツ**: Oracle APEXでは、ビュー名に「_P0001_V」のようなサフィックスを付けることで、ページ専用ビューであることを示す命名規則を使用していることが多い。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00001.sql | `src/apex/f141/application/pages/page_00001.sql` | ページ初期化処理とDynamic Actionの理解 |

**主要処理フロー**:
1. **行14-38**: `wwv_flow_imp_page.create_page`でページ基本設定
2. **行39-56**: Filterリージョン（ファセット検索）の定義
3. **行57-68**: Dashboardメインリージョンの定義
4. **行69-286**: Test Executions Reportのカラム定義
5. **行287-495**: Charts（Quota/Timeline）の定義
6. **行536-717**: ファセット検索アイテムの定義
7. **行718-1017**: Dynamic Action（イベント処理）の定義

#### Step 3: PL/SQLパッケージを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | p_fill_faceted_search_collectionの実装 |

**主要処理フロー**:
- **行297-315**: `p_fill_faceted_search_collection`でAPEX Collectionを生成
- **行59-115**: `get_faceted_search_dashboard_data`でファセット検索用パイプライン関数

### プログラム呼び出し階層図

```
Dashboard Page (Page 1)
    |
    +-- [Page Load - Dynamic Action: Lazy loading refresh]
    |       |
    |       +-- P1_LAZY_LOADING = 1 (Set Value)
    |       |
    |       +-- qa_apex_app_pkg.p_fill_faceted_search_collection
    |       |       |
    |       |       +-- apex_collection.create_collection_from_query
    |       |               |
    |       |               +-- qa_apex_app_pkg.get_faceted_search_dashboard_data
    |       |
    |       +-- Refresh Test Report (NATIVE_REFRESH)
    |       +-- Refresh Filter (NATIVE_REFRESH)
    |       +-- Refresh Timeline Chart (NATIVE_REFRESH)
    |       +-- Refresh Quota Chart (NATIVE_REFRESH)
    |
    +-- [Facet Change - Dynamic Action: Filter Regions]
    |       |
    |       +-- qa_apex_app_pkg.p_fill_faceted_search_collection
    |       +-- Refresh Reports and Charts
    |
    +-- [Button: Config Scheduler Job]
    |       |
    |       +-- Redirect to Page 9 (Modal)
    |
    +-- [Button: Test Result Files]
            |
            +-- Redirect to Page 5 (Modal)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

ファセット検索            qa_apex_app_pkg                     ダッシュボード
フィルター         ───>   .p_fill_faceted_search_collection   コンポーネント
(P1_CATEGORIES等)              |                                   |
                               v                                   v
                        APEX_COLLECTION              +-- Quota Chart
                        (キャッシュ)                 |   (円グラフ)
                               |                    |
                               v                    +-- Timeline Chart
                        QA_OVERVIEW_*_V                 (折れ線グラフ)
                        (ビュー群)                  |
                               |                    +-- Test Report
                               v                        (一覧表)
                        QA_TEST_RUNS / QA_RULES
                        (テーブル)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00001.sql | `src/apex/f141/application/pages/page_00001.sql` | ソース | Dashboard画面定義 |
| qa_apex_app_pkg.sql | `src/plsql/pkg/qa_apex_app_pkg.sql` | ソース | APEX画面用ヘルパーパッケージ |
| page_00009.sql | `src/apex/f141/application/pages/page_00009.sql` | ソース | Config Scheduler Jobモーダル |
| page_00005.sql | `src/apex/f141/application/pages/page_00005.sql` | ソース | Test Result Filesモーダル |
| page_00004.sql | `src/apex/f141/application/pages/page_00004.sql` | ソース | Invalid Objectsモーダル |
| page_00003.sql | `src/apex/f141/application/pages/page_00003.sql` | ソース | Runtime Errorモーダル |
| page_00011.sql | `src/apex/f141/application/pages/page_00011.sql` | ソース | Restart Unit Testモーダル |
