# 画面設計書 7-Rules

## 概要

本ドキュメントは、QUASTO（Oracle APEXアプリケーション）のRules画面（Page ID: 6）の設計書である。Rules画面は、品質チェックルールを一覧表示・管理するためのメイン画面である。

### 本画面の処理概要

Rules画面は、QUASTOの核となる品質チェックルールを管理する画面である。定義済みルールの一覧表示、新規ルールの追加、既存ルールの編集・削除、ルールファイルのインポート・エクスポート、ユニットテストパッケージの生成といった機能を提供する。

**業務上の目的・背景**：QUASTOはOracleデータベースオブジェクトの品質を検証するシステムである。品質チェックの基準となる「ルール」の管理は、システムの中心的な機能である。本画面は、管理者やデータベース開発者がルールを効率的に管理できるインターフェースを提供する。

**画面へのアクセス方法**：ナビゲーションメニューの「Rules」からアクセス。エイリアス「RULES」でのURLアクセスも可能。

**主要な操作・処理内容**：
1. ルール一覧の表示（インタラクティブ・レポート形式）
2. 「Add Rule」ボタンで新規ルール追加ダイアログを開く
3. ルール行をクリックして編集ダイアログを開く
4. 「Rule Files」ボタンでルールファイルインポート・エクスポートダイアログを開く
5. 「Generate unit tests for Schemes」ボタンでユニットテスト生成ダイアログを開く

**画面遷移**：
- 遷移元：Dashboard画面（メニュー）、他の画面からのナビゲーション
- 遷移先：Add/Edit Rule（モーダル）、Rule Files（モーダル）、Unit Test Generation（モーダル）

**権限による表示制御**：Protection Level「C」（認証必須）が設定されており、ログイン済みユーザーのみアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | ルール管理 | 主機能 | ルールの一覧表示、追加・編集画面への遷移 |
| 11 | ルールインポート・エクスポート | 副機能 | Rule Files画面への遷移 |
| 20 | Unit Testパッケージ生成 | 副機能 | Unit Test Generation画面への遷移 |

## 画面種別

一覧画面（インタラクティブ・レポート）

## URL/ルーティング

- Page ID: 6
- エイリアス: RULES
- URL例: `f?p=141:6:SESSION_ID`または`f?p=141:RULES:SESSION_ID`

## 入出力項目

Rules画面にはユーザー入力項目はない（フィルター機能はインタラクティブ・レポートの標準機能を使用）。

## 表示項目

### Rulesレポート（インタラクティブ・レポート）

| カラム名 | カラム別名 | 表示順序 | 説明 |
|---------|-----------|---------|------|
| (Edit Link) | QARU_ID | - | 編集リンク（fa-pencil-square-oアイコン） |
| Client | QARU_CLIENT_NAME | 10 | クライアント/プロジェクト名 |
| Number | QARU_RULE_NUMBER | 20 | ルール番号 |
| Name | QARU_NAME | 30 | ルール名 |
| Category | QARU_CATEGORY | 40 | カテゴリ（LOV表示） |
| Layer | QARU_LAYER | 50 | レイヤー（LOV表示） |
| Error Level | QARU_ERROR_LEVEL | 60 | エラーレベル（LOV表示） |
| Active | QARU_IS_ACTIVE | 70 | アクティブ状態（Yes/No LOV表示） |
| Object Types | QARU_OBJECT_TYPES | 80 | 対象オブジェクト種別 |

**レポート設定**:
- データソース: QA_RULESテーブル
- データなしメッセージ: No rules defined.
- ページネーション: X〜Y行表示（画面下部右寄せ）
- ダウンロード: メール/CSV有効
- 検索バー: 表示

### ボタン

| ボタン名 | 項目ID | 配置位置 | アクション | アイコン |
|---------|--------|----------|----------|--------|
| Add Rule | ADD_RULE | RIGHT_OF_IR_SEARCH_BAR | Add/Edit Ruleダイアログを開く | fa-plus |
| Rule Files | RULE_FILES | RIGHT_OF_IR_SEARCH_BAR | Rule Filesダイアログを開く | fa-file-o |
| Generate unit tests for Schemes | GENERATE_UNIT_TESTS | RIGHT_OF_IR_SEARCH_BAR | Unit Test Generationダイアログを開く | fa-cog |

## イベント仕様

### 1-Refresh Reports after Dialog closed

**トリガー**: Breadcrumb Barリージョンからのモーダルダイアログ終了時（apexafterclosecanceldialog）

**処理フロー**:
1. Rulesインタラクティブ・レポートをリフレッシュ

### レポートリンク

**Edit Link（ルール編集）**:
- トリガー: ルール行のペンシルアイコンクリック
- 処理: Add/Edit Rule画面（Page 7）をモーダルダイアログで開く
- パラメータ: P7_QARU_ID（ルールID）を渡す

## データベース更新仕様

### 操作別データベース影響一覧

Rules画面は主に参照のみで、直接的なデータベース更新は行わない（更新はAdd/Edit Rule画面で実行）。

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページロード | QA_RULES | SELECT | ルール一覧を取得 |

## メッセージ仕様

| メッセージID | 種別 | 表示条件 | メッセージ内容 |
|-------------|------|---------|---------------|
| - | 情報 | ルールが未定義 | No rules defined. |

## 例外処理

| 例外状態 | 表示・動作 |
|---------|----------|
| データが見つからない | 「No rules defined.」メッセージを表示 |

## 備考

- インタラクティブ・レポートの標準機能（フィルタ、ソート、列の表示/非表示、保存済みレポートなど）がすべて使用可能
- ルールの追加・編集・削除はAdd/Edit Rule画面（Page 7）で実行
- ルールファイル（JSON形式）のインポート・エクスポートはRule Files画面（Page 8）で実行
- Unit Testパッケージの生成・削除はUnit Test Generation画面（Page 2）で実行
- AutocompleteはセキュリティのためOFFに設定
- Left Side Columnテンプレートを使用

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 画面定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | page_00006.sql | `src/apex/f141/application/pages/page_00006.sql` | インタラクティブ・レポートとボタンの構成 |

**主要処理フロー**:
1. **行14-38**: `wwv_flow_imp_page.create_page`でページ基本設定
2. **行39-85**: Rulesインタラクティブ・レポートの定義
3. **行86-240**: ワークシート・カラム定義（QARU_*）
4. **行241-290**: ボタン定義（ADD_RULE、RULE_FILES、GENERATE_UNIT_TESTS）
5. **行291-320**: Dynamic Action（Refresh Reports after Dialog closed）

#### Step 2: 関連画面を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | Add/Edit Ruleモーダル |
| 2-2 | page_00008.sql | `src/apex/f141/application/pages/page_00008.sql` | Rule Filesモーダル |
| 2-3 | page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | Unit Test Generationモーダル |

### プログラム呼び出し階層図

```
Rules Page (Page 6)
    |
    +-- [Page Load]
    |       |
    |       +-- Interactive Report Query
    |               |
    |               +-- SELECT FROM QA_RULES
    |
    +-- [Button: ADD_RULE]
    |       |
    |       +-- Redirect to Page 7 (Modal, Insert mode)
    |
    +-- [Report Link: Edit]
    |       |
    |       +-- Redirect to Page 7 (Modal, Edit mode)
    |               |
    |               +-- P7_QARU_ID = Selected QARU_ID
    |
    +-- [Button: RULE_FILES]
    |       |
    |       +-- Redirect to Page 8 (Modal)
    |
    +-- [Button: GENERATE_UNIT_TESTS]
    |       |
    |       +-- Redirect to Page 2 (Modal)
    |
    +-- [Dialog Closed Event]
            |
            +-- Dynamic Action: Refresh Report
                    |
                    +-- NATIVE_REFRESH (Rules Report)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

（なし）                   Page 6 Load                      Rules一覧表示
                      ───>  Interactive Report         ───> (QA_RULES)
                                  |
                                  v
                           SELECT * FROM QA_RULES
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| page_00006.sql | `src/apex/f141/application/pages/page_00006.sql` | ソース | Rules画面定義 |
| page_00007.sql | `src/apex/f141/application/pages/page_00007.sql` | ソース | Add/Edit Ruleモーダル |
| page_00008.sql | `src/apex/f141/application/pages/page_00008.sql` | ソース | Rule Filesモーダル |
| page_00002.sql | `src/apex/f141/application/pages/page_00002.sql` | ソース | Unit Test Generationモーダル |
