---
generated_at: 2026-01-21 16:32:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-Dashboard

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00001.sql` (行1-1021)
- E-02: `src/plsql/pkg/qa_apex_app_pkg.sql` (行1-318)
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` (行3)
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行2-5)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` (行34-46, 69-88)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Page IDは1である | E-01（行15: p_id=>1） | ○ |
| C-02 | エイリアスはDASHBOARDである | E-01（行17: p_alias=>'DASHBOARD'） | ○ |
| C-03 | Protection LevelはCである | E-01（行36: p_protection_level=>'C'） | ○ |
| C-04 | Filterリージョンはファセット検索タイプである | E-01（行47: p_plug_source_type=>'NATIVE_FACETED_SEARCH'） | ○ |
| C-05 | Test Executions ReportはQA_OVERVIEW_TESTS_P0001_Vビューを使用 | E-01（行81: p_query_table=>'QA_OVERVIEW_TESTS_P0001_V'） | ○ |
| C-06 | Quota ChartはDonut（円グラフ）タイプである | E-01（行318: p_chart_type=>'donut'） | ○ |
| C-07 | Timeline Chartはline with areaタイプである | E-01（行375: p_chart_type=>'lineWithArea'） | ○ |
| C-08 | P1_LAZY_LOADINGはHidden項目である | E-01（行543: p_display_as=>'NATIVE_HIDDEN'） | ○ |
| C-09 | P1_CATEGORIESはチェックボックスタイプである | E-01（行566: p_display_as=>'NATIVE_CHECKBOX'） | ○ |
| C-10 | Config Scheduler Jobボタンは Page 9へリダイレクトする | E-01（行519: p_button_redirect_url=>'f?p=&APP_ID.:9:...'） | ○ |
| C-11 | Test Result Filesボタンは Page 5へリダイレクトする | E-01（行533: p_button_redirect_url=>'f?p=&APP_ID.:5:...'） | ○ |
| C-12 | Lazy loading refreshはreadyイベントで発火する | E-01（行903: p_bind_event_type=>'ready'） | ○ |
| C-13 | facetschangeイベントでFilter Regionsが発火する | E-01（行795: p_bind_event_type_custom=>'facetschange'） | ○ |
| C-14 | p_fill_faceted_search_collectionを呼び出している | E-01（行737, 806: 'qa_apex_app_pkg.p_fill_faceted_search_collection'） | ○ |
| C-15 | コレクション名はFACETED_SEARCH_DASHBOARD_DATA_P0001である | E-02（行304: p_collection_name => 'FACETED_SEARCH_DASHBOARD_DATA_P0001'） | ○ |
| C-16 | Quota ChartはQA_OVERVIEW_QUOTA_P0001_Vを使用 | E-01（行344: p_query_table=>'QA_OVERVIEW_QUOTA_P0001_V'） | ○ |
| C-17 | Success系列はQA_OVERVIEW_TIMELINE_SUCCESS_P0001_Vを使用 | E-01（行403: p_query_table=>'QA_OVERVIEW_TIMELINE_SUCCESS_P0001_V'） | ○ |
| C-18 | Failure系列はQA_OVERVIEW_TIMELINE_FAILURE_P0001_Vを使用 | E-01（行426: p_query_table=>'QA_OVERVIEW_TIMELINE_FAILURE_P0001_V'） | ○ |
| C-19 | Error系列はQA_OVERVIEW_TIMELINE_ERROR_P0001_Vを使用 | E-01（行450: p_query_table=>'QA_OVERVIEW_TIMELINE_ERROR_P0001_V'） | ○ |
| C-20 | waitSpinnerを使用して待機表示を行う | E-01（行937: 'waitSpinner = apex.widget.waitPopup()'） | ○ |
| C-21 | Login成功後にDashboardへ遷移する | E-05（行34, 71） | ○ |
| C-22 | Config Scheduler Jobへの遷移が可能 | E-05（行42-43, 85-86） | ○ |
| C-23 | Test Result Filesへの遷移が可能 | E-05（行43-44, 87-88） | ○ |
| C-24 | 機能No.26「ダッシュボードデータ取得」に関連 | E-04（行2） | ○ |
| C-25 | 機能No.31「ファセット検索コレクション生成」に関連 | E-04（行3） | ○ |
| C-26 | Timeline Chartの高さは300pxである | E-01（行377: p_height=>'300'） | ○ |
| C-27 | データなし時のメッセージは「No test results found.」 | E-01（行91, 335, 394: p_query_no_data_found/p_no_data_found_message） | ○ |
| C-28 | カスタムCSSでz-indexを調整している | E-01（行28-32: inline_css with z-index: 900） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードと完全に整合している

## 6) レビュアーチェックリスト（最小）
- [ ] QA_OVERVIEW_*_P0001_Vビューが正しく定義されているか確認
- [ ] APEX Collectionのパフォーマンスが大量データ時に問題ないか確認
- [ ] ファセット検索のフィルター連動が正しく動作するか確認
- [ ] モーダルダイアログ終了時のリフレッシュが全コンポーネントに適用されるか確認
- [ ] Lazy Loadingの待機時間（10秒）が適切か確認
