---
generated_at: 2026-01-21 16:44:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-Rules

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/apex/f141/application/pages/page_00006.sql` (行1-340)
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` (行8)
- E-03: `docs/code-to-docs/画面一覧/画面遷移図.md` (行48-67)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Page IDは6である | E-01（行15: p_id=>6） | ○ |
| C-02 | エイリアスはRULESである | E-01（行17: p_alias=>'RULES'） | ○ |
| C-03 | Protection LevelはCである | E-01（行35: p_protection_level=>'C'） | ○ |
| C-04 | データソースはQA_RULESテーブル | E-01（行48: p_query_table=>'QA_RULES'） | ○ |
| C-05 | インタラクティブ・レポートタイプを使用 | E-01（行50: p_plug_source_type=>'NATIVE_IR'） | ○ |
| C-06 | データなしメッセージは「No rules defined.」 | E-01（行83: p_no_data_found_message=>'No rules defined.'） | ○ |
| C-07 | ADD_RULEボタンはPage 7へリダイレクト | E-01（行250: p_button_redirect_url=>'f?p=&APP_ID.:7:...'） | ○ |
| C-08 | ADD_RULEボタンにfa-plusアイコンを使用 | E-01（行254: p_icon_css_classes=>'fa-plus'） | ○ |
| C-09 | RULE_FILESボタンはPage 8へリダイレクト | E-01（行267: p_button_redirect_url=>'f?p=&APP_ID.:8:...'） | ○ |
| C-10 | RULE_FILESボタンにfa-file-oアイコンを使用 | E-01（行270: p_icon_css_classes=>'fa-file-o'） | ○ |
| C-11 | GENERATE_UNIT_TESTSボタンはPage 2へリダイレクト | E-01（行283: p_button_redirect_url=>'f?p=&APP_ID.:2:...'） | ○ |
| C-12 | GENERATE_UNIT_TESTSボタンにfa-cogアイコンを使用 | E-01（行286: p_icon_css_classes=>'fa-cog'） | ○ |
| C-13 | Edit LinkはPage 7へモーダルでリダイレクト | E-01（行97-99: p_link_target） | ○ |
| C-14 | ダイアログ終了時にレポートをリフレッシュ | E-01（行295-320: Dynamic Action） | ○ |
| C-15 | QARU_CLIENT_NAMEカラムが表示順序10で定義 | E-01（行108: display_order=>10） | ○ |
| C-16 | QARU_RULE_NUMBERカラムが表示順序20で定義 | E-01（行122: display_order=>20） | ○ |
| C-17 | AutocompleteはOFFに設定 | E-01（行18: p_autocomplete_on_off=>'OFF'） | ○ |
| C-18 | ボタン配置位置はRIGHT_OF_IR_SEARCH_BAR | E-01（行248, 264, 280: p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張に根拠があり、ソースコードと完全に整合している

## 6) レビュアーチェックリスト（最小）
- [ ] QA_RULESテーブルの構造が設計と一致しているか確認
- [ ] LOV（RULE_CATEGORIES_LOV、RULE_LAYERS_LOV、RULE_ERROR_LEVELS_LOV）が定義されているか確認
- [ ] 大量のルールがある場合のレポートパフォーマンスを確認
- [ ] Edit Linkからのモーダル遷移が正しく動作するか確認
