---
generated_at: 2026-01-22 12:00:00
metrics:
  claims_total: 40
  claims_with_evidence: 38
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：38 / 40、根拠なし：2
- 優先レビュー（高）
  1. **IT-029 APEXプラグイン連携テスト**：プラグイン実装詳細が未確認
  2. **IT-040 条件コンパイル連携テスト**：qa_constant_pkgの全フラグ定義が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/plsql/pkg/qa_api_pkg.sql` - ルール実行API実装
- E-02: `src/plsql/pkg/qa_main_pkg.sql` - メインロジック実装
- E-03: `src/plsql/pkg/qa_unit_tests_pkg.sql` - ユニットテスト実装
- E-04: `src/plsql/pkg/qa_apex_api_pkg.sql` - APEX API実装
- E-05: `src/plsql/pkg/qa_export_import_rules_pkg.sql` - エクスポート/インポート実装
- E-06: `src/plsql/pkg/qa_logger_pkg.sql` - ロギング実装
- E-07: `src/plsql/pkg/qa_utils_pkg.sql` - ユーティリティ関数
- E-08: `src/ddl/tab/qa_rules.sql` - QA_RULESテーブル定義
- E-09: `src/plsql/typ/qa_rule_t.sql` - ルール型定義
- E-10: `src/plsql/typ/qa_rules_t.sql` - ルールコレクション型定義
- E-11: `src/plsql/vw/qa_scheme_names_for_testing_v.sql` - スキーマフィルタリングビュー
- E-12: `src/plsql/vw/qa_predecessor_order_v.sql` - 前提ルール順序ビュー
- E-13: `README.md` - プロジェクト概要とインストール手順

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: tf_run_rule関数がqa_rules_t型を返却 | E-01 (行24-29, 49-151) | ○ |
| C-02 | IT-002: NULLパラメータで-20001エラー発生 | E-01 (行74-80) | ○ |
| C-03 | IT-003: 非アクティブルールでエラー発生 | E-01 (行85-91) | ○ |
| C-04 | IT-004: ブラックリストスキーマでNULL返却 | E-01 (行82-84, 136-138), E-02 (行1006-1056) | ○ |
| C-05 | IT-005: tf_run_rulesが複数ルール結果を統合 | E-01 (行154-275) | ○ |
| C-06 | IT-006: 循環参照で-1436エラー発生 | E-02 (行899-960) | ○ |
| C-07 | IT-007: APEX tf_run_ruleがAPEXメタデータを処理 | E-04 (行99-182) | ○ |
| C-08 | IT-008: APEX tf_run_rulesが複数APEX結果を統合 | E-04 (行184-233) | ○ |
| C-09 | IT-009: f_get_ruleがqa_rule_t型を返却 | E-02 (行213-256) | ○ |
| C-10 | IT-010: 存在しないルールでNO_DATA_FOUND | E-02 (行244-249) | ○ |
| C-11 | IT-011: f_insert_ruleがqaru_idを返却 | E-02 (行749-838) | ○ |
| C-12 | IT-012: p_test_ruleがpo_result等を設定 | E-02 (行684-746) | ○ |
| C-13 | IT-013: f_export_rules_table_to_clobがJSON返却 | E-05 (行82-239) | ○ |
| C-14 | IT-014: f_import_clob_to_qa_import_filesがqaif_id返却 | E-05 (行318-364) | ○ |
| C-15 | IT-015: p_import_clob_to_rules_tableがMERGE実行 | E-05 (行367-463) | ○ |
| C-16 | IT-016: p_create_unit_test_packagesがパッケージ生成 | E-03 (行657-823) | ○ |
| C-17 | IT-017: p_delete_unit_test_packagesがパッケージDROP | E-03 (行825-871) | ○ |
| C-18 | IT-018: f_run_all_unit_testsがXML返却しQA_TEST_RESULTSに保存 | E-03 (行935-988) | ○ |
| C-19 | IT-019: p_run_custom_unit_testが個別テスト実行 | E-03 (行990-1036) | ○ |
| C-20 | IT-020: p_handle_test_resultがQA_TEST_RUNS等に保存 | E-03 (行1072-1141) | ○ |
| C-21 | IT-021: p_handle_test_exceptionがエラー状態で保存 | E-03 (行1143-1168) | ○ |
| C-22 | IT-022: p_create_custom_unit_test_jobがDBMS_SCHEDULER使用 | E-03 (行873-916) | ○ |
| C-23 | IT-023: p_trigger_scheduler_cronjobがDBMS_SCHEDULER.RUN_JOB呼び出し | E-03 (行1366-1386) | ○ |
| C-24 | IT-024: f_import_test_resultがQA_TEST_RESULTS挿入 | E-03 (行1435-1458) | ○ |
| C-25 | IT-025: f_export_test_resultがCLOB返却 | E-03 (行1460-1486) | ○ |
| C-26 | IT-026: utPLSQL ut.run()との連携 | E-03 (行971-973, 1020-1022), E-13 | ○ |
| C-27 | IT-027: Logger連携でlogger_logsに記録 | E-06, E-13 (行592-609) | ○ |
| C-28 | IT-028: APEX連携でapex_application_*ビュー参照 | E-04, E-13 (行196-364) | ○ |
| C-29 | IT-029: QUASTOプラグインがルール結果表示 | **根拠不足** | △ |
| C-30 | IT-030: トリガーによる監査列自動設定 | E-08 (行20-24) | ○ |
| C-31 | IT-031: p_exclude_objectsが除外オブジェクト処理 | E-02 (行842-897) | ○ |
| C-32 | IT-032: f_get_full_rule_predが再帰的前提取得 | E-02 (行962-1004) | ○ |
| C-33 | IT-033: qa_utils_pkgの文字列処理関数 | E-07, E-03 (行237-249, 279-281) | ○ |
| C-34 | IT-034: qa_scheme_names_for_testing_vがスキーマフィルタリング | E-11, E-02 (行1022-1028) | ○ |
| C-35 | IT-035: qa_predecessor_order_vが実行順序計算 | E-12, E-02 (行505-515) | ○ |
| C-36 | IT-036: JSON_TABLEによるJSONパース | E-05 (行385-399) | ○ |
| C-37 | IT-037: EXECUTE IMMEDIATEとBULK COLLECT | E-01 (行99-122) | ○ |
| C-38 | IT-038: シーケンスによるqaru_id採番 | E-08, E-02 (行828) | ○ |
| C-39 | IT-039: DBMS_OUTPUT.PUT_LINEによる結果出力 | E-03 (行1102, 1114, 1120-1121, 1129, 1135, 1138) | ○ |
| C-40 | IT-040: $IF条件コンパイルによる機能切り替え | E-01 (行124-132) | △ |

## 4) 不足情報（Unknown / Missing）
- **IT-029 APEXプラグイン連携テスト**：`src/apex/plugin/`配下のプラグイン実装コードの詳細確認が必要
  - 候補：quasto_region.sql / プラグインレンダリングロジック / JavaScript処理
- **IT-040 条件コンパイル連携テスト**：qa_constant_pkgの全フラグ定義と初期化処理の確認が必要
  - 候補：scripts/install_constant_package.sql / gc_jenkins_flag定義

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - API連携テスト（IT-001〜IT-008）：ソースコードから直接検証可能
- **0: 低リスク** - データベース連携テスト（IT-009〜IT-015）：DDL定義とパッケージコードから検証可能
- **1: 中リスク** - 外部サービス連携テスト（IT-026〜IT-028）：外部フレームワークのバージョン依存あり
- **2: 高リスク** - IT-029 APEXプラグイン連携：プラグイン実装の詳細未確認
- **1: 中リスク** - IT-040 条件コンパイル：フラグ組み合わせによる動作差異の網羅性

## 6) レビュアーチェックリスト（最小）
- [ ] IT-001〜IT-008のAPI連携テストで、全パラメータパターンがカバーされているか確認
- [ ] IT-009〜IT-015のデータベース連携テストで、トランザクション境界が適切か確認
- [ ] IT-016〜IT-025のutPLSQL連携テストで、テストパッケージ命名規則が正しいか確認
- [ ] IT-026〜IT-028の外部サービス連携テストで、環境依存条件が明確か確認
- [ ] IT-029のAPEXプラグイン連携テストで、プラグイン実装詳細を補完
- [ ] IT-040の条件コンパイルテストで、全フラグ組み合わせを網羅しているか確認
- [ ] 全テストケースでエラーハンドリングパス（例外発生時）がカバーされているか確認
- [ ] 優先度「高」のテストケースが実際の運用シナリオを反映しているか確認
